SkillBarColor[1] = {r = 0, g = 0.6, b = 1, prefix = "MANA"}
SkillBarColor[4] = {r = 1, g = 0, b = 1, prefix = "VIGOR_POINTS"}
UnitRelationColor[3] = {r = 1, g = 0.8, b = 0}
UnitRelationColor[4] = {r = 0, g = 0.8, b = 0.4}
UnitRelationColor[5] = {r = 0, g = 0.4, b = 1}

-- _____________________________________________

    -------    Edited by Bytecode    -------
-- _____________________________________________
	
NPC_HITPOINT = {}

function SUI_TargetFrame_OnLoad(this)
	TargetFrame:UnregisterEvent("UNIT_NAME_UPDATE")
	TargetFrame:UnregisterEvent("UNIT_LEVEL")
	TargetFrame:UnregisterEvent("UNIT_PORTRAIT_UPDATE")
	TargetFrame:UnregisterEvent("RAID_TARGET_CHANGED")
	TargetFrame:UnregisterEvent("UNIT_RELATION")
	TargetFrame.healthBar:UnregisterEvent("UNIT_HEALTH")
	TargetFrame.healthBar:UnregisterEvent("UNIT_MAXHEALTH")
	TargetFrame.manaBar:UnregisterEvent("UNIT_MANA")
	TargetFrame.manaBar:UnregisterEvent("UNIT_MAXMANA")
	TargetFrame.skillBar:UnregisterEvent("UNIT_SKILL")
	TargetFrame.skillBar:UnregisterEvent("UNIT_MAXSKILL")
	TargetFrame:UnregisterEvent("UNIT_TARGET_CHANGED")
	TargetFrame:UnregisterEvent("UNIT_BUFF_CHANGED")
	TargetFrame:UnregisterEvent("UNIT_CLASS_CHANGED")
	TargetFrame:Hide()
	
	this:RegisterForClicks("LeftButton", "RightButton")
	this:RegisterEvent("UNIT_NAME_UPDATE")
	this:RegisterEvent("UNIT_LEVEL")
	this:RegisterEvent("UNIT_CLASS_CHANGED")
	this:RegisterEvent("UNIT_PORTRAIT_UPDATE")
	this:RegisterEvent("RAID_TARGET_CHANGED")
	
	this:RegisterEvent("UNIT_HEALTH")
	this:RegisterEvent("UNIT_MAXHEALTH")
	this:RegisterEvent("UNIT_MANA")
	this:RegisterEvent("UNIT_MAXMANA")
	this:RegisterEvent("UNIT_SKILL")
	this:RegisterEvent("UNIT_MAXSKILL")
	
	this:RegisterEvent("LOADING_END")
	this:RegisterEvent("UNIT_TARGET_CHANGED")
	this:RegisterEvent("UNIT_BUFF_CHANGED")
	this:RegisterEvent("UNIT_CASTINGTIME")
	this:RegisterEvent("UNIT_RELATION")
	
	this.unit = "target"
	this.buffs = 66
	this.debuffs = 22
	
	for i = 2, this.buffs do
		local buff = getglobal("SUI_TargetFrameBuffButton"..i)
		if i <= 11 then
			buff:ClearAllAnchors()
			buff:SetAnchor("LEFT", "RIGHT", "SUI_TargetFrameBuffButton"..i - 1, 0, 0)
		else
			buff:ClearAllAnchors()
			buff:SetAnchor("TOP", "BOTTOM", "SUI_TargetFrameBuffButton"..i - 11, 0, 0)
		end
	end
	for i = 2, this.debuffs do
		local debuff = getglobal("SUI_TargetFrameDebuffButton"..i)
		if i <= 11 then
			debuff:ClearAllAnchors()
			debuff:SetAnchor("LEFT", "RIGHT", "SUI_TargetFrameDebuffButton"..i - 1, 0, 0)
		else
			debuff:ClearAllAnchors()
			debuff:SetAnchor("TOP", "BOTTOM", "SUI_TargetFrameDebuffButton"..i - 11, 0, 0)
		end
	end
end

function SUI_TargetFrame_OnEvent(this, event)
	if event == "LOADING_END" then
		SUI_TargetFrame_Update(this)
	elseif event == "UNIT_TARGET_CHANGED" and arg1 == "player" then
		SUI_TargetFrame_Update(this)
	elseif event == "RAID_TARGET_CHANGED" and this:IsVisible() then
		RaidTargetFrame_Update(SUI_TargetFrameRaidTargetFrame, "target")
	elseif arg1 == "target" then
		if event == "UNIT_NAME_UPDATE" then
			SUI_UnitFrameName_Update(this)
		elseif event == "UNIT_LEVEL" or event == "UNIT_CLASS_CHANGED" then
			SUI_UnitFrameLevel_Update(this)
		elseif event == "UNIT_PORTRAIT_UPDATE" then
			SUI_UnitFramePortrait_Update(this)
		elseif event == "UNIT_HEALTH" or event == "UNIT_MAXHEALTH" then
			SUI_TargetFrameHealthBar_Update(this)
		elseif event == "UNIT_MANA" or event == "UNIT_MAXMANA" then
			SUI_UnitFrameManaBar_Update(this)
		elseif event == "UNIT_SKILL" or event == "UNIT_MAXSKILL" then
			SUI_UnitFrameSkillBar_Update(this)
		elseif event == "UNIT_BUFF_CHANGED" then
			SUI_UnitFrameBuffButton_Update(this)
		elseif event == "UNIT_CASTINGTIME" then
			SUI_UnitFrameCastingBar_Update(this)
		elseif event == "UNIT_RELATION" then
			SUI_UnitFrameRelation_Update(this)
		end
	end
end

function SUI_TargetFrame_OnClick(this, key)
	if SpellIsTargeting() and key == "RBUTTON" then
		SpellStopCasting()
		return
	end
	
	if key == "LBUTTON" then
		if SpellIsTargeting() then
			SpellTargetUnit("target")
		elseif ( CursorHasItem() ) then
			DropItemOnUnit("target")
		end
	else
		ToggleDropDownMenu(TargetFrameDropDown, 1, nil, "SUI_TargetFrame")
	end
end

function SUI_TargetFrame_OnUpdate(this, elapsedTime)
	if SUI_TargetFrameCastingBar.maxValue then
		local name, maximum, current = UnitCastingTime(this.unit)
		SUI_TargetFrameCastingBar:SetValue(current)
		SUI_TargetFrameCastingBarDuration:SetText(string.format("%.1f/%.1f", current, maximum)..UNIT_SECOND)
	elseif SUI_TargetFrameCastingBar.fadeOut then
		local alpha = SUI_TargetFrameCastingBar:GetAlpha() - elapsedTime
		if alpha > 0 then
			SUI_TargetFrameCastingBar:SetAlpha(alpha)
		else
			SUI_TargetFrameCastingBar.maxValue = nil
			SUI_TargetFrameCastingBar.fadeOut = nil
			SUI_TargetFrameCastingBar:Hide()
		end
	end
	
	for i = 1, 66 do
		local duration = getglobal(this:GetName().."BuffButton"..i.."Duration")
		local leftTime = UnitBuffLeftTime("target", i)
		if leftTime then
			duration:SetText(SecondsToTimeAbbrev(leftTime))
			duration:Show()
		else
			duration:Hide()
		end
	end
	for i = 1, 22 do
		local duration = getglobal(this:GetName().."DebuffButton"..i.."Duration")
		local leftTime = UnitDebuffLeftTime("target", i)
		if leftTime then
			duration:SetText(SecondsToTimeAbbrev(leftTime))
			duration:Show()
		else
			duration:Hide()
		end
	end
end

function SUI_TargetFrame_Update(this)
	if UnitExists("target") then
		local sex = UnitSex("target")
		if sex > 2 then
			SUI_TargetFrameHealthBarName:SetColor(1, 0.6, 0)
		elseif sex > 1 then
			SUI_TargetFrameHealthBarName:SetColor(1, 0.2, 0)
		else
			SUI_TargetFrameHealthBarName:SetColor(1, 1, 1)
		end
		SUI_UnitFrameName_Update(this)
		SUI_UnitFrameLevel_Update(this)
		SUI_UnitFramePortrait_Update(this)
		RaidTargetFrame_Update(SUI_TargetFrameRaidTargetFrame, "target")
		SUI_TargetFrameHealthBar_Update(this)
		SUI_UnitFrameManaBar_Update(this)
		SUI_UnitFrameSkillBar_Update(this)
		SUI_UnitFrameBuffButton_Update(this)
		SUI_UnitFrameCastingBar_Update(this)
		SUI_UnitFrameRelation_Update(this)
	
		this:Show()
	else
		this:Hide()
	end
end


function SUI_TargetOfTargetFrame_OnLoad(this)
	TargetTargetFrame:UnregisterEvent("UNIT_NAME_UPDATE")
	TargetTargetFrame:UnregisterEvent("UNIT_LEVEL")
	TargetTargetFrame:UnregisterEvent("UNIT_PORTRAIT_UPDATE")
	TargetTargetFrame:UnregisterEvent("RAID_TARGET_CHANGED")
	TargetTargetFrame:UnregisterEvent("UNIT_RELATION")
	TargetTargetFrame.healthBar:UnregisterEvent("UNIT_HEALTH")
	TargetTargetFrame.healthBar:UnregisterEvent("UNIT_MAXHEALTH")
	TargetTargetFrame.manaBar:UnregisterEvent("UNIT_MANA")
	TargetTargetFrame.manaBar:UnregisterEvent("UNIT_MAXMANA")
	TargetTargetFrame.skillBar:UnregisterEvent("UNIT_SKILL")
	TargetTargetFrame.skillBar:UnregisterEvent("UNIT_MAXSKILL")
	TargetTargetFrame:UnregisterEvent("UNIT_TARGET_CHANGED")
	TargetTargetFrame:UnregisterEvent("UNIT_BUFF_CHANGED")
	TargetTargetFrame:UnregisterEvent("UNIT_CLASS_CHANGED")
	TargetTargetFrame:Hide()
	
	this:RegisterForClicks("LeftButton", "RightButton")
	this:RegisterEvent("UNIT_NAME_UPDATE")
	this:RegisterEvent("UNIT_LEVEL")
	this:RegisterEvent("UNIT_CLASS_CHANGED")
	this:RegisterEvent("UNIT_PORTRAIT_UPDATE")
	this:RegisterEvent("RAID_TARGET_CHANGED")
	
	this:RegisterEvent("UNIT_HEALTH")
	this:RegisterEvent("UNIT_MAXHEALTH")
	this:RegisterEvent("UNIT_MANA")
	this:RegisterEvent("UNIT_MAXMANA")
	this:RegisterEvent("UNIT_SKILL")
	this:RegisterEvent("UNIT_MAXSKILL")
	
	this:RegisterEvent("LOADING_END")
	this:RegisterEvent("UNIT_TARGET_CHANGED")
	this:RegisterEvent("UNIT_BUFF_CHANGED")
	this:RegisterEvent("UNIT_CASTINGTIME")
	this:RegisterEvent("UNIT_RELATION")
	
	this.unit = "targettarget"
	this.buffs = 10
	this.debuffs = 10
	
	for i = 2, this.buffs do
		local buff = getglobal("SUI_TargetOfTargetFrameBuffButton"..i)
		if i <= 10 then
			buff:ClearAllAnchors()
			buff:SetAnchor("LEFT", "RIGHT", "SUI_TargetOfTargetFrameBuffButton"..i - 1, 0, 0)
		else
			buff:ClearAllAnchors()
			buff:SetAnchor("TOP", "BOTTOM", "SUI_TargetOfTargetFrameBuffButton"..i - 10, 0, 0)
		end
	end
	for i = 1, this.debuffs do
		local debuff = getglobal("SUI_TargetOfTargetFrameDebuffButton"..i)
		if i <= 10 then
			debuff:ClearAllAnchors()
			debuff:SetAnchor("LEFT", "RIGHT", "SUI_TargetOfTargetFrameDebuffButton"..i - 1, 0, 0)
		else
			debuff:ClearAllAnchors()
			debuff:SetAnchor("TOP", "BOTTOM", "SUI_TargetOfTargetFrameDebuffButton"..i - 10, 0, 0)
		end
	end
end

function SUI_TargetOfTargetFrame_OnEvent(this, event)
	if event == "LOADING_END" then
		SUI_TargetOfTargetFrame_Update(this)
	elseif event == "UNIT_TARGET_CHANGED" and arg1 == "target" or arg1 == "player" then
		SUI_TargetOfTargetFrame_Update(this)
	elseif event == "RAID_TARGET_CHANGED" and this:IsVisible() then
		RaidTargetFrame_Update(SUI_TargetOfTargetFrameRaidTargetFrame, "targettarget")
	elseif arg1 == "targettarget" then
		if event == "UNIT_NAME_UPDATE" then
			SUI_UnitFrameName_Update(this)
		elseif event == "UNIT_LEVEL" or event == "UNIT_CLASS_CHANGED" then
			SUI_UnitFrameLevel_Update(this)
		elseif event == "UNIT_PORTRAIT_UPDATE" then
			SUI_UnitFramePortrait_Update(this)
		elseif event == "UNIT_HEALTH" or event == "UNIT_MAXHEALTH" then
			SUI_TargetOfTargetFrameHealthBar_Update(this)
		elseif event == "UNIT_MANA" or event == "UNIT_MAXMANA" then
			SUI_TargetOfTargetFrameManaBar_Update(this)
		elseif event == "UNIT_SKILL" or event == "UNIT_MAXSKILL" then
			SUI_TargetOfTargetFrameSkillBar_Update(this)
		elseif event == "UNIT_BUFF_CHANGED" then
			SUI_UnitFrameBuffButton_Update(this)
		elseif event == "UNIT_CASTINGTIME" then
			SUI_UnitFrameCastingBar_Update(this)
		elseif event == "UNIT_RELATION" then
			SUI_UnitFrameRelation_Update(this)
		end
	end
end

function SUI_TargetOfTargetFrame_OnUpdate(this, elapsedTime)
	if  SUI_TargetOfTargetFrameCastingBar.maxValue then
		local name, maximum, current = UnitCastingTime(this.unit)
		SUI_TargetOfTargetFrameCastingBar:SetValue(current)
	elseif SUI_TargetOfTargetFrameCastingBar.fadeOut then
		local alpha = SUI_TargetOfTargetFrameCastingBar:GetAlpha() - elapsedTime
		if alpha > 0 then
			SUI_TargetOfTargetFrameCastingBar:SetAlpha(alpha)
		else
			SUI_TargetOfTargetFrameCastingBar.maxValue = nil
			SUI_TargetOfTargetFrameCastingBar.fadeOut = nil
			SUI_TargetOfTargetFrameCastingBar:Hide()
		end
	end
end

function SUI_TargetOfTargetFrame_OnClick(this, key)
	if key == "LBUTTON" then
		if SpellIsTargeting() then
			SpellTargetUnit(this.unit)
		else
			TargetUnit(this.unit)
		end
	else
		ToggleDropDownMenu(TargettargetFrameDropDown, 1, nil, SUI_TargetOfTargetFrame)
	end
end

function SUI_TargetOfTargetFrame_Update(this)
	if UnitExists("targettarget") then
		SUI_UnitFrameName_Update(this)
		SUI_UnitFrameLevel_Update(this)
		SUI_UnitFramePortrait_Update(this)
		RaidTargetFrame_Update(SUI_TargetOfTargetFrameRaidTargetFrame, "targettarget")
		SUI_TargetOfTargetFrameHealthBar_Update(this)
		SUI_TargetOfTargetFrameManaBar_Update(this)
		SUI_TargetOfTargetFrameSkillBar_Update(this)
		SUI_UnitFrameBuffButton_Update(this)
		SUI_UnitFrameCastingBar_Update(this)
		SUI_UnitFrameRelation_Update(this)
		this:Show()
	else
		this:Hide()
	end
end

function SUI_TargetOfTargetFrameHealthBar_Update(this)
	local _, current = UnitHealth("targettarget")
    local _, maximum = UnitMaxHealth("targettarget")
    local bar = getglobal(this:GetName().."HealthBar")
    local text = getglobal(bar:GetName().."Text")
    bar:SetMaxValue(maximum)
    bar:SetValue(current)    

	
	SUI_TargetOfTargetFrameHealthBar:SetMaxValue(maximum)
	SUI_TargetOfTargetFrameHealthBar:SetValue(current)
	SUI_TargetOfTargetFrameHealthBarText:SetText(MoneyNormalization(current).."/"..MoneyNormalization(maximum).." ("..string.format("%.2f",current / maximum * 100).."%)")
end

function SUI_TargetOfTargetFrameManaBar_Update(this)
	local current = UnitMana("targettarget")
	local maximum = UnitMaxMana("targettarget")
	
	SUI_TargetOfTargetFrameManaBar:SetMaxValue(maximum)
	SUI_TargetOfTargetFrameManaBar:SetValue(current)
	if maximum > 0 then
		SUI_TargetOfTargetFrameManaBarText:SetText(string.format("%0.0f", current / maximum * 100).."%")
	else
		SUI_TargetOfTargetFrameManaBarText:SetText("")
	end
end

function SUI_TargetOfTargetFrameSkillBar_Update(this)
	local current = UnitSkill("targettarget")
	local maximum = UnitMaxSkill("targettarget")
	
	SUI_TargetOfTargetFrameSkillBar:SetMaxValue(maximum)
	SUI_TargetOfTargetFrameSkillBar:SetValue(current)
	if maximum > 0 then
		SUI_TargetOfTargetFrameSkillBarText:SetText(string.format("%0.0f", current / maximum * 100).."%")
	else
		SUI_TargetOfTargetFrameSkillBarText:SetText("")
	end
end

----------------------------------------------------------------------------------

function SUI_UnitFrameName_Update(this)
	local name = getglobal(this:GetName().."HealthBarName")
	if UnitIsPlayer(this.unit) then
		name:SetText(string.upper(UnitName(this.unit)))
	else
		name:SetText(UnitName(this.unit))
	end
	if this.unit == "pet" or this.unit == "targettarget" then
		return
	end
	
	local race = getglobal(this:GetName().."HealthBarRace")
	if UnitRace(this.unit) and UnitIsPlayer(this.unit) then
		race:SetText(UnitRace(this.unit))
	else
		race:SetText("")
	end
end

function SUI_UnitFrameLevel_Update(this)
	local level, sublevel = UnitLevel(this.unit)
	local class, subclass = UnitClass(this.unit)
	local manabar = getglobal(this:GetName().."ManaBar")
	local primary = getglobal(manabar:GetName().."Class")
	
	local mana = SkillBarColor[UnitManaType(this.unit)]
	manabar:SetBarColor(mana.r, mana.g, mana.b)
	if level > 0 and class ~= "" then
		primary:SetText(class.." ["..level.."]")
	else
		primary:SetText("")
	end
	
	if this.unit == "pet" then
		return
	end
	
	local skillbar = getglobal(this:GetName().."SkillBar")
	local secondary = getglobal(skillbar:GetName().."Class")
	local skill = SkillBarColor[UnitSkillType(this.unit)]
	skillbar:SetBarColor(skill.r, skill.g, skill.b)
	if sublevel > 0 and subclass ~= "" then
		secondary:SetText(subclass.." ["..sublevel.."]")
	else
		secondary:SetText("")
	end
end

function SUI_UnitFramePortrait_Update(this)
	local portrait = getglobal(this:GetName().."Portrait")
	portrait:SetUnit(this.unit, nil, true)
end

--function SUI_TargetFrameHealthBar_Update(this)
	--local _,current = UnitHealth(this.unit)
	--local _,maximum = UnitMaxHealth(this.unit)
	--local bar = getglobal(this:GetName().."HealthBar")
	--local text = getglobal(bar:GetName().."Text")
	
	--bar:SetMaxValue(maximum)
	--bar:SetValue(current)
	
	--if UnitIsNPC(this.unit) and not UnitMaster(this.unit) then
		--HitPointFrame_Update(this.unit)
		--if NPC_HITPOINT[UnitName(this.unit)][UnitLevel(this.unit)] then
			--local maximum = NPC_HITPOINT[UnitName(this.unit)][UnitLevel(this.unit)]
			--text:SetText(MoneyNormalization(math.floor(current * maximum / 100)).."/"..MoneyNormalization(maximum).." ("..string.format("%.1f", current).."%)")
		--else
			--text:SetText(current.." %")
		--end
	--else
		--text:SetText(MoneyNormalization(current).."/"..MoneyNormalization(maximum).." ("..string.format("%.1f", current / maximum * 100).."%)")
	--end
--end


 --function SUI_TargetFrameHealthBar_Update(this)
   -- local _, current = UnitHealth(this.unit)
   -- local _, maximum = UnitMaxHealth(this.unit)
   -- local bar = getglobal(this:GetName().."HealthBar")
   -- local text = getglobal(bar:GetName().."Text")
    
   -- bar:SetMaxValue(maximum)
---- bar:SetValue(current)    
   -- text:SetText(MoneyNormalization(current).."/"..MoneyNormalization(maximum).." ("..string.format("%.2f",MoneyNormalization(current) / MoneyNormalization(maximum) * 100).."%)"))
	  --text:SetText(MoneyNormalization(current).."/"..MoneyNormalization(maximum).." ("..string.format("%.2f",current / maximum * 100).."%)")
--end


function SUI_TargetFrameHealthBar_Update(this)
    local _, current = UnitHealth(this.unit)
    local _, maximum = UnitMaxHealth(this.unit)
    local bar = getglobal(this:GetName().."HealthBar")
    local text = getglobal(bar:GetName().."Text")
    
    bar:SetMaxValue(maximum)
    bar:SetValue(current)    
    text:SetText(MoneyNormalization(current).."/"..MoneyNormalization(maximum).." ("..string.format("%.2f",current / maximum * 100).."%)")
end

function SUI_UnitFrameManaBar_Update(this)
	local info = SkillBarColor[UnitManaType(this.unit)]
	local current = UnitMana(this.unit)
	local maximum = UnitMaxMana(this.unit)
	local bar = getglobal(this:GetName().."ManaBar")
	local text = getglobal(bar:GetName().."Text")
	
	bar:SetBarColor(info.r, info.g, info.b);
	bar:SetMaxValue(maximum)
	bar:SetValue(current)
	if maximum > 0 then
		text:SetText(MoneyNormalization(current).."/"..MoneyNormalization(maximum))
	else
		text:SetText("")
	end
end

function SUI_UnitFrameSkillBar_Update(this)
	local info = SkillBarColor[UnitSkillType(this.unit)]
	local current = UnitSkill(this.unit)
	local maximum = UnitMaxSkill(this.unit)
	local bar = getglobal(this:GetName().."SkillBar")
	local text = getglobal(bar:GetName().."Text")
	
	bar:SetBarColor(info.r, info.g, info.b);
	bar:SetMaxValue(maximum)
	bar:SetValue(current)
	if maximum > 0 then
		text:SetText(MoneyNormalization(current).."/"..MoneyNormalization(maximum))
	else
		text:SetText("")
	end
end

function SUI_UnitFrameBuffButton_Update(this)
	local name, texture, count, button
	local buffcount = 0
	for i = 1, this.buffs do
		button = getglobal(this:GetName().."BuffButton"..i)
		name, texture, count = UnitBuff(this.unit, i)
		if name then
			if count < 1 then
				count = ""
			end
			getglobal(button:GetName().."Icon"):SetTexture(texture)
			getglobal(button:GetName().."Count"):SetText(count)
			buffcount = buffcount + 1
			button:Show()
		else
			button:Hide()
		end
	end
	for i = 1, this.debuffs do
		button = getglobal(this:GetName().."DebuffButton"..i)
		name, texture, count = UnitDebuff(this.unit, i)
		if name then
			if count < 1 then
				count = ""
			end
			getglobal(button:GetName().."Icon"):SetTexture(texture)
			getglobal(button:GetName().."Count"):SetText(count)
			button:Show()
		else
			button:Hide()
		end
	end
	
	if string.find(this.unit, "party") then
		return
	end
	
	local height = getglobal(this:GetName().."DebuffButton1"):GetHeight()
	getglobal(this:GetName().."DebuffButton1"):ClearAllAnchors()
	getglobal(this:GetName().."DebuffButton1"):SetAnchor("TOPLEFT", "TOPLEFT", this:GetName().."BuffButton1", 0, math.ceil(buffcount / 8) * height)
end

function SUI_UnitFrameCastingBar_Update(this)
	local name, maximum, current = UnitCastingTime(this.unit)
	local bar = getglobal(this:GetName().."CastingBar")
	local text = getglobal(bar:GetName().."Text")
	if name and maximum > 0 then
		text:SetText(name)
		bar.fadeOut = 1
		bar.maxValue = maximum
		bar:SetMaxValue(maximum)
		bar:SetValue(current)
		bar:SetAlpha(1)
		bar:Show()
		
		if this.unit == "targettarget" then
			getglobal(this:GetName().."BuffButton1"):ClearAllAnchors()
			getglobal(this:GetName().."BuffButton1"):SetAnchor("TOPLEFT", "BOTTOMLEFT", this, 0, 16)
		else
			getglobal(this:GetName().."BuffButton1"):ClearAllAnchors()
			getglobal(this:GetName().."BuffButton1"):SetAnchor("TOPLEFT", "BOTTOMLEFT", this, 0, 16)
		end
	elseif bar:IsVisible() then
		bar.maxValue = nil
		
		if this.unit == "targettarget" then
			getglobal(this:GetName().."BuffButton1"):ClearAllAnchors()
			getglobal(this:GetName().."BuffButton1"):SetAnchor("TOPLEFT", "BOTTOMLEFT", this, 0, 0)
		else
			getglobal(this:GetName().."BuffButton1"):ClearAllAnchors()
			getglobal(this:GetName().."BuffButton1"):SetAnchor("TOPLEFT", "BOTTOMLEFT", this, 0, 0)
		end
	end
end


function SUI_UnitFrameRelation_Update(this)
	local r, g, b
	local bar = getglobal(this:GetName().."HealthBar")
	if UnitCanAttack(this.unit, "player") then
		if UnitCanAttack("player", this.unit) then
			r = UnitRelationColor[1].r
			g = UnitRelationColor[1].g
			b = UnitRelationColor[1].b
		else
			r = UnitRelationColor[2].r
			g = UnitRelationColor[2].g
			b = UnitRelationColor[2].b
		end
	elseif UnitCanAttack("player", this.unit) then
		r = UnitRelationColor[3].r
		g = UnitRelationColor[3].g
		b = UnitRelationColor[3].b
	elseif UnitInParty(this.unit) then
		r = UnitRelationColor[5].r
		g = UnitRelationColor[5].g
		b = UnitRelationColor[5].b
	else
		r = UnitRelationColor[4].r
		g = UnitRelationColor[4].g
		b = UnitRelationColor[4].b
	end
	bar:SetBarColor(1, 0, 0)
end

----------------------------------------------------------------------------------

function HitPointFrame_OnLoad(this)
	this:RegisterEvent("UPDATE_MOUSEOVER_UNIT")
end

function HitPointFrame_OnEvent(this, event)
	if event == "UPDATE_MOUSEOVER_UNIT" then
		if UnitExists("mouseover") and UnitCanAttack("player", "mouseover") then
			HitPointFrame_Update("mouseover")
		end
	end
end

function HitPointFrame_Update(unit)
	if UnitIsNPC(unit) and not UnitIsMine(unit) and not UnitMaster(unit) then
		local name = UnitName(unit)
		local level = UnitLevel(unit)
		
		if type(NPC_HITPOINT[name]) ~= "table" then
			NPC_HITPOINT[name] = {}
		end
		if UnitHealth(unit) == 100 then
			local truehp = UnitChangeHealth(unit)
			NPC_HITPOINT[name][level] = truehp
		end
	end
end