SUI_minimap_config = {}

function SUI_MinimapFrame_OnLoad(this)
	MinimapFrameBorder:Hide()
	MinimapRimFrame:Hide()
	MinimapDisableFrame:Hide()
	MinimapFramePlusButton:Hide()
	MinimapFrameMinusButton:Hide()
	MinimapFramePlayerPosition:Hide()
	MinimapFrameTimeBorder:Hide()
	
	MinimapViewFrame:ClearAllAnchors()
	MinimapViewFrame:SetAnchor("CENTER", "CENTER", SUI_MinimapFrame, 0, 0)
	MinimapViewFrame:SetSize(194, 194)
	MinimapFrameTime:ClearAllAnchors()
	MinimapFrameTime:SetAnchor("BOTTOMRIGHT", "BOTTOMRIGHT", MinimapViewFrame, 0, 0)
	MinimapFrameTime:SetSize(24, 24)
	MinimapFrameTimeCircle:SetSize(24, 24)
	MinimapFrameTimeCircleTexture:SetSize(24, 24)
	MinimapFrameTimeCircleTexture:SetMaskFile("interface/common/block-fill")
	
	MinimapDisableFrameTexture:SetTexture("interface/addons/fslimui/textures/empty")
	
	if not START_UP_TIME then
		START_UP_TIME = GetTime()
	end
	
	this:RegisterEvent("LOADING_END")
	this:RegisterEvent("ZONE_CHANGED")
	
	MINIMAPFRAME_MASK_NAME = "interface/common/block-fill"
	InitializeMiniMap(MINIMAPFRAME_VIEWFRAME_NAME, MINIMAPFRAME_MASK_NAME, MINIMAPFRAME_PLAYERCURSOR, MINIMAPFRAME_DUELRANGE, MINIMAPFRAME_ICON_NAME, MINIMAPFRAME_ICON_COUNT)
end

function SUI_MinimapFrame_OnEvent(this, event)
	SUI_MinimapZoneName:SetText(GetZoneName())
end

function SUI_PlayerPositionFrame_OnUpdate(elapsedTime)
	local x, y = GetPlayerWorldMapPos()
	if x and y then
		local pos = string.format( "%.1f:%.1f" , x * 100 , y * 100 )
		SUI_PlayerPositionFrameText:SetText(pos)
	else
		SUI_PlayerPositionFrameText:SetText("")
	end
end

function SUI_PlayerPositionFrame_OnMouseWheel(this, delta)
	if delta > 0 then
		OnClick_MinimapPlusButton()
	else
		OnClick_MinimapMinusButton()
	end
end


function TimeConvert(seconds)
	local outstr
	local hh = math.floor(seconds / 3600)
	seconds = seconds - (hh * 3600)
	local mm = math.floor(seconds / 60)
	seconds = seconds - (mm * 60)
	local ss = math.floor(seconds)
	
	if hh > 0 then
		outstr = hh..UNIT_HOUR..string.format("%02d", mm)..UNIT_MINUTE..string.format("%02d", ss)..UNIT_SECOND
	elseif mm > 0 then
		outstr = mm..UNIT_MINUTE..string.format("%02d", ss)..UNIT_SECOND
	else
		outstr = ss..UNIT_SECOND
	end
	
	return outstr
end


function SUI_MinimapConfig_OnLoad(this)
	this:RegisterEvent("VARIABLES_LOADED")
	SaveVariables("SUI_minimap_config")
	this.parent = string.sub(this:GetName(), 7)
	local SUI_minimapbutton = {BULLETINBOARD, UI_NPCTRACK_TITLE, BSF_STR_TITLE, ACCOUNT_SHOP, UI_MINIMAP_OPTION, BATTLE_GROUND_NAME, UI_MINIMAP_RESTORE_UI, PARTY_BOARD_TITLE1, PET_FRAME_BUTTON, WORLD_BATTLE_GROUND_BUTTON}
	getglobal(this:GetName().."Text"):SetText(SUI_minimapbutton[this:GetID()])
end

function SUI_MinimapConfig_OnEvent(this, event)
	if SUI_minimap_config[this.parent] == nil then
		SUI_minimap_config[this.parent] = false
	end
	getglobal(this:GetName()):SetChecked(SUI_minimap_config[this.parent])
	if SUI_minimap_config[this.parent] then
		getglobal(this.parent):Hide()
	else
		getglobal(this.parent):Show()
	end
end

function SUI_MinimapConfig_OnClick(this)
	SUI_minimap_config[this.parent] = this:IsChecked()
	if SUI_minimap_config[this.parent] then
		getglobal(this.parent):Hide()
	else
		getglobal(this.parent):Show()
	end
end


function OnEnter_MinimapTimeIcon(this)
	local gametime = GetCurrentGameTime()
	local strTime = nil
	if gametime < 30 then
		strTime = UI_MINIMAP_TIME_MORNING
	elseif gametime < 120 then
		strTime = UI_MINIMAP_TIME_DAYTIME
	elseif gametime < 150 then
		strTime = UI_MINIMAP_TIME_DUSK
	else
		strTime = UI_MINIMAP_TIME_NIGHT
	end
	GameTooltip:SetOwner(this, "ANCHOR_BOTTOMLEFT", 0, 0)
	GameTooltip:SetText(strTime, 1, 1, 1)
	
	local tempTime = GetTime() - START_UP_TIME
	GameTooltip:AddDoubleLine(GUILD_STR_ONLINE, TimeConvert(tempTime), 0, 1, 0, 0, 1, 0)
	GameTooltip:Show()
end


local buttons = {
	MinimapFrameQuestTrackButton		= {normal = "craftframe\\openqueueframe_normal", pushed = "craftframe\\openqueueframe_depress", checked = "craftframe\\openqueueframe_disable"},
	MinimapBeautyStudioButton			= {normal = "runesofmagic_picture\\sys_questtrack_setting_3normal", pushed = "runesofmagic_picture\\sys_questtrack_setting_3mousedown"},
	MinimapNpcTrackButton				= {normal = "craftframe\\showalllist_normal", pushed = "craftframe\\showalllist_depress"},
	MinimapFrameStoreButton				= {normal = "bagframe\\goodsbutton-normal", pushed = "bagframe\\goodsbutton-depress"},
	MinimapFrameBulletinButton			= {normal = "guildhouseframe\\guildhouse_button_bbs_normal", pushed = "guildhouseframe\\guildhouse_button_bbs_depress"},
	--MinimapFrameBugGartherButton		= {normal = "buttons\\query-normal", pushed = "buttons\\query-depress"},
	MinimapFrameOptionButton			= {normal = "houseframe\\housesfriend-setup-normal", pushed = "houseframe\\housesfriend-setup-depress"},
	MinimapFrameRestoreUIButton			= {normal = "petframe\\petframebutton-return-normal", pushed = "petframe\\petframebutton-return-depress"},
	MinimapFrameBattleGroundButton		= {normal = "guildhouseframe\\guildhouse_button_building_normal", pushed = "guildhouseframe\\guildhouse_button_building_depress"},
	PlayerFramePartyBoardButton			= {normal = "houseframe\\housesfriend-add-normal", pushed = "houseframe\\housesfriend-add-depress"},
	PlayerFramePetButton				= {normal = "petframe\\petframebutton-walk-normal", pushed = "petframe\\petframebutton-walk-depress"},
	PlayerFrameWorldBattleGroundButton	= {normal = "guildhouseframe\\guildbankconfig_normal", pushed = "guildhouseframe\\guildbankconfig_depress"},
}

for k, v in pairs(buttons) do
	getglobal(k):SetSize(22, 22)
	getglobal(k):GetNormalTexture():SetFile("interface\\"..v.normal)
	getglobal(k):GetNormalTexture():SetSize(22, 22)
	getglobal(k):GetPushedTexture():SetFile("interface\\"..v.pushed)
	getglobal(k):GetPushedTexture():SetSize(22, 22)
	getglobal(k):GetHighlightTexture():SetFile("interface/addons/fslimui/textures/highlight")
	getglobal(k):GetHighlightTexture():SetSize(22, 22)
	if v.checked then
		getglobal(k):GetCheckedTexture():SetFile("interface\\"..v.checked)
		getglobal(k):GetCheckedTexture():SetSize(22, 22)
	end
end