function SUI_CastingBarFrame_OnLoad(this)
	CastingBarFrame:UnregisterEvent("CASTING_START")
	CastingBarFrame:UnregisterEvent("CASTING_STOP")
	CastingBarFrame:UnregisterEvent("CASTING_FAILED")
	CastingBarFrame:UnregisterEvent("CASTING_DELAYED")
	this:RegisterEvent("CASTING_START")
	this:RegisterEvent("CASTING_STOP")
	this:RegisterEvent("CASTING_FAILED")
	this:RegisterEvent("CASTING_DELAYED")
end

function SUI_CastingBarFrame_OnEvent(this, event)
	if event == "CASTING_START" then
		this.casting = true
		this:SetAlpha(1.0)
		SUI_CastingBarFrameStatusBar:SetBarColor(0.1, 0.7, 0.7)
		SUI_CastingBarFrameStatusBarText:SetText(arg1)
		this.max = arg2
		this.min = 0
		SUI_CastingBarFrameStatusBar:SetMinValue(this.min)
		SUI_CastingBarFrameStatusBar:SetMaxValue(this.max)
		this:Show()
	elseif event == "CASTING_STOP" then
		if this:IsVisible() then
			SUI_CastingBarFrameStatusBar:SetBarColor(0.0, 1, 0)
			this.casting = nil
			this.flash = 0
			this.fadeOut = true
		end
	elseif event == "CASTING_FAILED" then
		if this:IsVisible() then
			SUI_CastingBarFrameStatusBar:SetBarColor(1, 0, 0)
			this.casting = nil
			this.flash = 0
			this.fadeOut = true
		end
	elseif event == "CASTING_DELAYED" then
		if this:IsVisible() then
			this.min = this.min + arg1
			this.max = this.max + arg1
			this:SetMinValue(this.min)
			this:SetMaxValue(this.max)
		end
	end
end

function SUI_CastingBarFrame_OnUpdate(this, elapsed)
	if this.casting then
		this.min = this.min + elapsed
		if this.min > this.max then
			this.min = this.max
		end
		SUI_CastingBarFrameStatusBar:SetValue(this.min)
		SUI_CastingBarFrameStatusBarDuration:SetText(string.format("%.1f/%.1f", this.min, this.max)..UNIT_SECOND)
	elseif this.flash then
		this.flash = this.flash + 0.05
		if this.flash > 1 then
			this.flash = nil
		end
	elseif this.fadeOut then
		local alpha = this:GetAlpha() - 0.05
		if alpha > 0 then
			this:SetAlpha(alpha)
		else
			this.fadeOut = nil
			this:Hide()
		end
	end
end