SkillBarColor[1] = {r = 0, g = 0.6, b = 1, prefix = "MANA"}
SkillBarColor[4] = {r = 1, g = 0, b = 1, prefix = "VIGOR_POINTS"}

function SUI_PartyFrame_OnLoad(this)	
	this:RegisterForClicks("LeftButton", "RightButton")
	this:RegisterEvent("UNIT_NAME_UPDATE")
	this:RegisterEvent("UNIT_LEVEL")
	this:RegisterEvent("UNIT_CLASS_CHANGED")
	this:RegisterEvent("UNIT_PORTRAIT_UPDATE")
	this:RegisterEvent("RAID_TARGET_CHANGED")
	
	this:RegisterEvent("UNIT_HEALTH")
	this:RegisterEvent("UNIT_MAXHEALTH")
	this:RegisterEvent("UNIT_MANA")
	this:RegisterEvent("UNIT_MAXMANA")
	this:RegisterEvent("UNIT_SKILL")
	this:RegisterEvent("UNIT_MAXSKILL")

	this:RegisterEvent("LOADING_END")
	this:RegisterEvent("UNIT_BUFF_CHANGED")
	this:RegisterEvent("PARTY_MEMBER_CHANGED")
	this:RegisterEvent("PARTY_LEADER_CHANGED")
	this:RegisterEvent("LOOT_METHOD_CHANGED")
	
	this.unit = "party"..this:GetID()
	this.buffs = 8
	this.debuffs = 8
	
	for i = 2, this.buffs do
		local buff = getglobal(this:GetName().."BuffButton"..i)
		if i <= 8 then
			buff:ClearAllAnchors()
			buff:SetAnchor("LEFT", "RIGHT", this:GetName().."BuffButton"..i - 1, 0, 0)
		else
			buff:ClearAllAnchors()
			buff:SetAnchor("TOP", "BOTTOM", this:GetName().."BuffButton"..i - 8, 0, 0)
		end
	end
	for i = 2, this.debuffs do
		local debuff = getglobal(this:GetName().."DebuffButton"..i)
		if i <= 8 then
			debuff:ClearAllAnchors()
			debuff:SetAnchor("LEFT", "RIGHT", this:GetName().."DebuffButton"..i - 1, 0, 0)
		else
			debuff:ClearAllAnchors()
			debuff:SetAnchor("TOP", "BOTTOM", this:GetName().."DebuffButton"..i - 8, 0, 0)
		end
	end
end

function SUI_PartyFrame_OnEvent(this, event)
	if event == "LOADING_END" then
		local frame = getglobal("UnitFrame_party"..this:GetID())
		frame:UnregisterEvent("UNIT_NAME_UPDATE")
		frame:UnregisterEvent("UNIT_LEVEL")
		frame:UnregisterEvent("UNIT_PORTRAIT_UPDATE")
		frame:UnregisterEvent("RAID_TARGET_CHANGED")
		frame:UnregisterEvent("UNIT_RELATION")
		frame.healthBar:UnregisterEvent("UNIT_HEALTH")
		frame.healthBar:UnregisterEvent("UNIT_MAXHEALTH")
		frame.manaBar:UnregisterEvent("UNIT_MANA")
		frame.manaBar:UnregisterEvent("UNIT_MAXMANA")
		frame.skillBar:UnregisterEvent("UNIT_SKILL")
		frame.skillBar:UnregisterEvent("UNIT_MAXSKILL")
		frame:UnregisterEvent("PARTY_MEMBER_CHANGED")
		frame:UnregisterEvent("PARTY_LEADER_CHANGED")
		frame:UnregisterEvent("UNIT_CLASS_CHANGED")
		frame:UnregisterEvent("UNIT_BUFF_CHANGED")
		frame:UnregisterEvent("LOOT_METHOD_CHANGED")
		frame:Hide()
		SUI_PartyFrame_Update(this)
	elseif event == "PARTY_MEMBER_CHANGED" then
		SUI_PartyFrame_Update(this)
	elseif event == "RAID_TARGET_CHANGED" and this:IsVisible() then
		RaidTargetFrame_Update(getglobal(this:GetName().."RaidTargetFrame"), this.unit)
	elseif event == "PARTY_LEADER_CHANGED" then
		SUI_PartyFrame_UpdateLeader(this)
	elseif event == "LOOT_METHOD_CHANGED" then
		SUI_PartyFrame_UpdateLooter(this)
	elseif arg1 == this.unit then
		if event == "UNIT_NAME_UPDATE" then
			SUI_UnitFrameName_Update(this)
		elseif event == "UNIT_LEVEL" or event == "UNIT_CLASS_CHANGED" then
			SUI_PartyFrameLevel_Update(this)
		elseif event == "UNIT_PORTRAIT_UPDATE" then
			SUI_UnitFramePortrait_Update(this)
		elseif event == "UNIT_HEALTH" or event == "UNIT_MAXHEALTH" then
			SUI_UnitFrameHealthBar_Update(this)
		elseif event == "UNIT_MANA" or event == "UNIT_MAXMANA" then
			SUI_UnitFrameManaBar_Update(this)
		elseif event == "UNIT_SKILL" or event == "UNIT_MAXSKILL" then
			SUI_UnitFrameSkillBar_Update(this)
		elseif event == "UNIT_BUFF_CHANGED" then
			SUI_UnitFrameBuffButton_Update(this)
		end
	end
end

function SUI_PartyFrame_OnClick(this, key)
	if key == "LBUTTON" then
		if SpellIsTargeting() then
			SpellTargetUnit(this.unit)
		-- elseif CursorHasItem() then
			-- DropItemOnUnit(this.unit)
		else
			TargetUnit(this.unit)
		end
	else
		ToggleDropDownMenu(getglobal("UnitFrame_party"..this:GetID().."DropDown"), 1, nil, this:GetName())
	end
end

function SUI_PartyFrame_Update(this)
	if GetNumRaidMembers() > 0 and g_RaidFrameOption.HidePartyInRaid then
		this:Hide()
		return
	end

	local name, online = GetPartyMember(this:GetID())
	if name then
		if online then
			this:SetAlpha(1)
		else
			this:SetAlpha(0.5)
		end
		
		SUI_UnitFrameName_Update(this)
		SUI_PartyFrameLevel_Update(this)
		SUI_UnitFramePortrait_Update(this)
		RaidTargetFrame_Update(getglobal(this:GetName().."RaidTargetFrame"), this.unit)
		SUI_UnitFrameHealthBar_Update(this)
		SUI_UnitFrameManaBar_Update(this)
		SUI_UnitFrameBuffButton_Update(this)
		SUI_PartyFrame_UpdateLeader(this)
		SUI_PartyFrame_UpdateLooter(this)
		this:Show()
	else
		this:Hide()
	end
end
		
function SUI_PartyFrame_UpdateLeader(this)
	local icon = getglobal(this:GetName() .. "LeaderIcon")
	if GetPartyLeaderIndex() == this:GetID() then
		icon:Show()
	else
		icon:Hide()
	end
end

function SUI_PartyFrame_UpdateLooter(this)
	local icon = getglobal(this:GetName() .. "LooterIcon")
	if UnitIsMasterLooter(this.unit) then
		icon:Show()
	else
		icon:Hide()
	end
end

function SUI_PartyFrameLevel_Update(this)
	SUI_UnitFrameLevel_Update(this)
	
	local bar = getglobal(this:GetName().."HealthBar")
	local color = g_ClassColors[UnitClassToken(this.unit)]
	bar:SetBarColor(color.r, color.g, color.b)
end

----------------------------------------------------------------------------------

function SUI_UnitFrameName_Update(this)
	local name = getglobal(this:GetName().."HealthBarName")
	if UnitIsPlayer(this.unit) then
		name:SetText(string.upper(UnitName(this.unit)))
	else
		name:SetText(UnitName(this.unit))
	end
	if this.unit == "pet" or this.unit == "targettarget" then
		return
	end
	
	local race = getglobal(this:GetName().."HealthBarRace")
	if UnitRace(this.unit) then
		race:SetText(UnitRace(this.unit))
	else
		race:SetText("")
	end
end

function SUI_UnitFrameLevel_Update(this)
	local level, sublevel = UnitLevel(this.unit)
	local class, subclass = UnitClass(this.unit)
	local manabar = getglobal(this:GetName().."ManaBar")
	local primary = getglobal(manabar:GetName().."Class")
	
	local mana = SkillBarColor[UnitManaType(this.unit)]
	manabar:SetBarColor(mana.r, mana.g, mana.b)
	if level > 0 and class ~= "" then
		primary:SetText(class.." ["..level.."]")
	else
		primary:SetText("")
	end
	
	if this.unit == "pet" then
		return
	end
	
	local skillbar = getglobal(this:GetName().."SkillBar")
	local secondary = getglobal(skillbar:GetName().."Class")
	local skill = SkillBarColor[UnitSkillType(this.unit)]
	skillbar:SetBarColor(skill.r, skill.g, skill.b)
	if sublevel > 0 and subclass ~= "" then
		secondary:SetText(subclass.." ["..sublevel.."]")
	else
		secondary:SetText("")
	end
end

function SUI_UnitFramePortrait_Update(this)
	local portrait = getglobal(this:GetName().."Portrait")
	portrait:SetUnit(this.unit, nil, true)
end

function SUI_UnitFrameHealthBar_Update(this)
	local current = UnitHealth(this.unit)
	local maximum = UnitMaxHealth(this.unit)
	local bar = getglobal(this:GetName().."HealthBar")
	local text = getglobal(bar:GetName().."Text")
	
	bar:SetMaxValue(maximum)
	bar:SetValue(current)
	
	if UnitIsNPC(this.unit) and not UnitMaster(this.unit) then
		HitPointFrame_Update(this.unit)
		if NPC_HITPOINT[UnitName(this.unit)][UnitLevel(this.unit)] then
			local maximum = NPC_HITPOINT[UnitName(this.unit)][UnitLevel(this.unit)]
			text:SetText(MoneyNormalization(math.floor(current * maximum / 100)).."/"..MoneyNormalization(maximum))
		else
			text:SetText(current.." %")
		end
	else
		text:SetText(MoneyNormalization(current).."/"..MoneyNormalization(maximum))
	end
end

function SUI_UnitFrameManaBar_Update(this)
	local info = SkillBarColor[UnitManaType(this.unit)]
	local current = UnitMana(this.unit)
	local maximum = UnitMaxMana(this.unit)
	local bar = getglobal(this:GetName().."ManaBar")
	local text = getglobal(bar:GetName().."Text")
	
	bar:SetBarColor(info.r, info.g, info.b);
	bar:SetMaxValue(maximum)
	bar:SetValue(current)
	if maximum > 0 then
		text:SetText(MoneyNormalization(current).."/"..MoneyNormalization(maximum))
	else
		text:SetText("")
	end
end

function SUI_UnitFrameSkillBar_Update(this)
	local info = SkillBarColor[UnitSkillType(this.unit)]
	local current = UnitSkill(this.unit)
	local maximum = UnitMaxSkill(this.unit)
	local bar = getglobal(this:GetName().."SkillBar")
	local text = getglobal(bar:GetName().."Text")
	
	bar:SetBarColor(info.r, info.g, info.b);
	bar:SetMaxValue(maximum)
	bar:SetValue(current)
	if maximum > 0 then
		text:SetText(MoneyNormalization(current).."/"..MoneyNormalization(maximum))
	else
		text:SetText("")
	end
end

function SUI_UnitFrameBuffButton_Update(this)
	local name, texture, count, button
	local buffcount = 0
	for i = 1, this.buffs do
		button = getglobal(this:GetName().."BuffButton"..i)
		name, texture, count = UnitBuff(this.unit, i)
		if name then
			if count < 1 then
				count = ""
			end
			getglobal(button:GetName().."Icon"):SetTexture(texture)
			getglobal(button:GetName().."Count"):SetText(count)
			buffcount = buffcount + 1
			button:Show()
		else
			button:Hide()
		end
	end
	for i = 1, this.debuffs do
		button = getglobal(this:GetName().."DebuffButton"..i)
		name, texture, count = UnitDebuff(this.unit, i)
		if name then
			if count < 1 then
				count = ""
			end
			getglobal(button:GetName().."Icon"):SetTexture(texture)
			getglobal(button:GetName().."Count"):SetText(count)
			button:Show()
		else
			button:Hide()
		end
	end
	
	if string.find(this.unit, "party") then
		return
	end
	
	local height = getglobal(this:GetName().."DebuffButton1"):GetHeight()
	getglobal(this:GetName().."DebuffButton1"):ClearAllAnchors()
	getglobal(this:GetName().."DebuffButton1"):SetAnchor("TOPLEFT", "TOPLEFT", this:GetName().."BuffButton1", 0, math.ceil(buffcount / 8) * height)
end

function SUI_UnitFrameCastingBar_Update(this)
	local name, maximum, current = UnitCastingTime(this.unit)
	local bar = getglobal(this:GetName().."CastingBar")
	local text = getglobal(bar:GetName().."Text")
	if name and maximum > 0 then
		text:SetText(name)
		bar.fadeOut = 1
		bar.maxValue = maximum
		bar:SetMaxValue(maximum)
		bar:SetValue(current)
		bar:SetAlpha(1)
		bar:Show()
		
		if this.unit == "targettarget" then
			getglobal(this:GetName().."BuffButton1"):ClearAllAnchors()
			getglobal(this:GetName().."BuffButton1"):SetAnchor("TOPLEFT", "BOTTOMLEFT", this, 40, 16)
		else
			getglobal(this:GetName().."BuffButton1"):ClearAllAnchors()
			getglobal(this:GetName().."BuffButton1"):SetAnchor("TOPLEFT", "BOTTOMLEFT", this, 0, 16)
		end
	elseif bar:IsVisible() then
		bar.maxValue = nil
		
		if this.unit == "targettarget" then
			getglobal(this:GetName().."BuffButton1"):ClearAllAnchors()
			getglobal(this:GetName().."BuffButton1"):SetAnchor("TOPLEFT", "BOTTOMLEFT", this, 40, 0)
		else
			getglobal(this:GetName().."BuffButton1"):ClearAllAnchors()
			getglobal(this:GetName().."BuffButton1"):SetAnchor("TOPLEFT", "BOTTOMLEFT", this, 0, 0)
		end
	end
end

function SUI_UnitFrameRelation_Update(this)
	local r, g, b
	local bar = getglobal(this:GetName().."HealthBar")
	if UnitCanAttack(this.unit, "player") then
		if UnitCanAttack("player", this.unit) then
			r = UnitRelationColor[1].r
			g = UnitRelationColor[1].g
			b = UnitRelationColor[1].b
		else
			r = UnitRelationColor[2].r
			g = UnitRelationColor[2].g
			b = UnitRelationColor[2].b
		end
	elseif UnitCanAttack("player", this.unit) then
		r = UnitRelationColor[3].r
		g = UnitRelationColor[3].g
		b = UnitRelationColor[3].b
	elseif UnitInParty(this.unit) then
		r = UnitRelationColor[5].r
		g = UnitRelationColor[5].g
		b = UnitRelationColor[5].b
	else
		r = UnitRelationColor[4].r
		g = UnitRelationColor[4].g
		b = UnitRelationColor[4].b
	end
	bar:SetBarColor(r, g, b)
end
