ACTIONBUTTON_OFFSET = 0

for k, v in pairs({"MainActionBarFrame", "BottomActionBarFrame", "RightActionBarFrame" , "LeftActionBarFrame", "ActionBarFrame5" , "ActionBarFrame6" , "ActionBarFrame7" , "ActionBarFrame8"}) do
	getglobal(v.."ButtonEX"):GetNormalTexture():SetFile("interface/addons/fslimui/textures/empty")
	getglobal(v.."Button1"):ClearAllAnchors()
	getglobal(v.."Button1"):SetAnchor("TOPLEFT", "TOPLEFT", v, 0, 0)
	for i = 1, 20 do
		getglobal(v.."Button"..i.."Icon"):SetSize(32, 32)
		getglobal(v.."Button"..i.."Icon"):SetTexCoord(0.0625, 0.9375, 0.0625, 0.9375)
		getglobal(v.."Button"..i.."Border"):SetTexture("interface/addons/fslimui/textures/button36x36_enabled")
		getglobal(v.."Button"..i.."Border"):SetSize(36, 36)
		getglobal(v.."Button"..i.."Border"):SetTexCoord(0.21875, 0.78125, 0.21875, 0.78125)
		getglobal(v.."Button"..i.."Invalid"):SetTexture("interface/addons/fslimui/textures/button36x36_disabled")
		getglobal(v.."Button"..i.."Invalid"):SetSize(36, 36)
		getglobal(v.."Button"..i.."Invalid"):SetTexCoord(0.21875, 0.78125, 0.21875, 0.78125)
		getglobal(v.."Button"..i):GetPushedTexture():SetFile("interface/addons/fslimui/textures/button36x36")
		getglobal(v.."Button"..i):GetPushedTexture():SetSize(36, 36)
		getglobal(v.."Button"..i):GetPushedTexture():SetColor(0.4, 0.4, 0.4)
		getglobal(v.."Button"..i):GetPushedTexture():SetTexCoord(0.21875, 0.78125, 0.21875, 0.78125)
		getglobal(v.."Button"..i):GetHighlightTexture():SetFile("interface/addons/fslimui/textures/highlight2")
		getglobal(v.."Button"..i):GetHighlightTexture():SetSize(36, 36)
		getglobal(v.."Button"..i.."Hotkey"):SetColor(1, 1, 1)	
	end
end

PetActionBarFrame:SetSize(360, 36)
PetActionBarFrame:SetBackdrop({
        edgeFile = "interface/addons/fslimui/textures/empty",
        bgFile = "interface/addons/fslimui/textures/empty",        
        BackgroundInsets = { top = 0, left = 0, bottom = 0, right = 0 },
        EdgeSize = 0,
        TileSize = 0,
    })
PetActionMoveButton:GetNormalTexture():SetFile("interface/addons/fslimui/textures/empty")
PetActionMoveButton:ClearAllAnchors()
PetActionMoveButton:SetAnchor("TOPLEFT", "TOPLEFT", "PetActionBarFrame", -8, -8)
for i = 1, 10 do
	getglobal("PetActionBarButton"..i):ClearAllAnchors()
	getglobal("PetActionBarButton"..i):SetAnchor("LEFT", "LEFT", "PetActionBarFrame", 36 * (i - 1), 0)
	getglobal("PetActionBarButton"..i.."Icon"):SetSize(36, 36)
	getglobal("PetActionBarButton"..i.."Icon"):SetTexCoord(0.0625, 0.9375, 0.0625, 0.9375)
	getglobal("PetActionBarButton"..i.."Border"):SetTexture("interface/addons/fslimui/textures/button36x36Black")
	getglobal("PetActionBarButton"..i.."Border"):SetSize(38, 38)
	getglobal("PetActionBarButton"..i.."Border"):SetTexCoord(0.21875, 0.78125, 0.21875, 0.78125)
	getglobal("PetActionBarButton"..i.."Invalid"):SetTexture("interface/addons/fslimui/textures/button36x36Black")
	getglobal("PetActionBarButton"..i.."Invalid"):SetSize(38, 38)
	getglobal("PetActionBarButton"..i.."Invalid"):SetTexCoord(0.21875, 0.78125, 0.21875, 0.78125)
	getglobal("PetActionBarButton"..i):GetPushedTexture():SetFile("interface/addons/fslimui/textures/button36x36Black")
	getglobal("PetActionBarButton"..i):GetPushedTexture():SetSize(38, 38)
	getglobal("PetActionBarButton"..i):GetPushedTexture():SetColor(0, 0, 0)
	getglobal("PetActionBarButton"..i):GetPushedTexture():SetTexCoord(0.21875, 0.78125, 0.21875, 0.78125)
	getglobal("PetActionBarButton"..i):GetHighlightTexture():SetFile("interface/addons/fslimui/textures/empty")
	getglobal("PetActionBarButton"..i):GetHighlightTexture():SetSize(38, 38)
	getglobal("PetActionBarButton"..i.."Hotkey"):SetColor(1, 1, 1)
end

ExtraActionBarFrame:SetSize(360, 36)
ExtraActionBarFrameLeft:SetTexture("interface/addons/fslimui/textures/empty")
ExtraActionBarFrameRight:SetTexture("interface/addons/fslimui/textures/empty")
ExtraActionBarFrameMiddle:SetTexture("interface/addons/fslimui/textures/empty")
ExtraActionBarFrameAnchorButton:GetNormalTexture():SetFile("interface/addons/fslimui/textures/empty")
ExtraActionBarFrameAnchorButton:ClearAllAnchors()
ExtraActionBarFrameAnchorButton:SetAnchor("TOPLEFT", "TOPLEFT", "ExtraActionBarFrame", -8, -8)
for i = 1, 10 do
	getglobal("ExtraActionBarButton"..i):ClearAllAnchors()
	getglobal("ExtraActionBarButton"..i):SetAnchor("LEFT", "LEFT", "ExtraActionBarFrame", 36 * (i - 1), 0)
	getglobal("ExtraActionBarButton"..i.."Icon"):SetSize(36, 36)
	getglobal("ExtraActionBarButton"..i.."Icon"):SetTexCoord(0.0625, 0.9375, 0.0625, 0.9375)
	getglobal("ExtraActionBarButton"..i.."Border"):SetTexture("interface/addons/fslimui/textures/button36x36Black")
	getglobal("ExtraActionBarButton"..i.."Border"):SetSize(38, 38)
	getglobal("ExtraActionBarButton"..i.."Border"):SetTexCoord(0.21875, 0.78125, 0.21875, 0.78125)
	getglobal("ExtraActionBarButton"..i.."Invalid"):SetTexture("interface/addons/fslimui/textures/button36x36Black")
	getglobal("ExtraActionBarButton"..i.."Invalid"):SetSize(38, 38)
	getglobal("ExtraActionBarButton"..i.."Invalid"):SetTexCoord(0.21875, 0.78125, 0.21875, 0.78125)
	getglobal("ExtraActionBarButton"..i):GetPushedTexture():SetFile("interface/addons/fslimui/textures/button36x36Black")
	getglobal("ExtraActionBarButton"..i):GetPushedTexture():SetSize(38, 38)
	getglobal("ExtraActionBarButton"..i):GetPushedTexture():SetColor(0, 0, 0)
	getglobal("ExtraActionBarButton"..i):GetPushedTexture():SetTexCoord(0.21875, 0.78125, 0.21875, 0.78125)
	getglobal("ExtraActionBarButton"..i):GetHighlightTexture():SetFile("interface/addons/fslimui/textures/empty")
	getglobal("ExtraActionBarButton"..i):GetHighlightTexture():SetSize(38, 38)
	getglobal("ExtraActionBarButton"..i.."Hotkey"):SetColor(1, 1, 1)
end

-- ImplementActionBarFrame:SetSize(360, 36)
-- ImplementActionBarFrameMoveButton:GetNormalTexture():SetFile("interface/addons/fslimui/textures/empty")
-- ImplementActionBarFrameMoveButton:ClearAllAnchors()
-- ImplementActionBarFrameMoveButton:SetAnchor("TOPLEFT", "TOPLEFT", "PetActionBarFrame", -8, -8)
for i = 1, 10 do
	getglobal("ImplementActionButton"..i):ClearAllAnchors()
	getglobal("ImplementActionButton"..i):SetAnchor("LEFT", "LEFT", "ImplementActionBarFrame", 36 * (i - 1), 0)
	getglobal("ImplementActionButton"..i.."Icon"):SetSize(32, 32)
	getglobal("ImplementActionButton"..i.."Icon"):SetTexCoord(0.0625, 0.9375, 0.0625, 0.9375)
	getglobal("ImplementActionButton"..i.."Border"):SetTexture("interface/addons/fslimui/textures/button36x36Black")
	getglobal("ImplementActionButton"..i.."Border"):SetSize(38, 38)
	getglobal("ImplementActionButton"..i.."Border"):SetTexCoord(0.21875, 0.78125, 0.21875, 0.78125)
	getglobal("ImplementActionButton"..i.."Invalid"):SetTexture("interface/addons/fslimui/textures/button36x36Black")
	getglobal("ImplementActionButton"..i.."Invalid"):SetSize(38, 38)
	getglobal("ImplementActionButton"..i.."Invalid"):SetTexCoord(0.21875, 0.78125, 0.21875, 0.78125)
	getglobal("ImplementActionButton"..i):GetPushedTexture():SetFile("interface/addons/fslimui/textures/button36x36Black")
	getglobal("ImplementActionButton"..i):GetPushedTexture():SetSize(38, 38)
	getglobal("ImplementActionButton"..i):GetPushedTexture():SetColor(0, 0, 0)
	getglobal("ImplementActionButton"..i):GetPushedTexture():SetTexCoord(0.21875, 0.78125, 0.21875, 0.78125)
	getglobal("ImplementActionButton"..i):GetHighlightTexture():SetFile("interface/addons/fslimui/textures/empty")
	getglobal("ImplementActionButton"..i):GetHighlightTexture():SetSize(38, 38)
	getglobal("ImplementActionButton"..i.."Hotkey"):SetColor(1, 1, 1)
end

function ActionButton_Update(this)
	local icon = getglobal(this:GetName().."Icon");
	local texture, name, count, locked, wore, continued = GetActionInfo(ActionButton_GetButtonID(this));

	if ( wore ) then
		count = 1;
		getglobal(this:GetName().."Border"):SetTexture("interface/addons/fslimui/textures/button36x36Black")
	else
		getglobal(this:GetName().."Border"):SetTexture("interface/addons/fslimui/textures/button36x36Black")
	end
	
	if ( continued ) then
		getglobal(this:GetName().."Continued"):Show();
	else
		getglobal(this:GetName().."Continued"):Hide();
	end

	if ( texture ) then
		icon:Show();
		icon:SetTexture(texture);
	else
		icon:Hide();
	end	
	local buttonName = getglobal(this:GetName().."Name");
	if ( name ) then
		buttonName:Show();
		buttonName:SetText(name);
	else
		buttonName:Hide();
	end
	
	SetItemButtonCount(this, count);
	SetItemButtonLuminance(this, count == 0);
	ActionButton_UpdateCooldown(this);
	ActionButton_UpdateBorder(this);
end

function ActionBarFrame_Update(this)
	local button;
	local info = {};
	info.visible, info.count, info.row = GetActionBarSetting(this:GetID());

	local column=1;
	if ( info.row < 1 ) then
		info.row = 1;
	end
	local row = 1;	

	if ( ImplementActionBarFrame:IsVisible() == false and (info.visible == 1 or info.visible == true) ) then
		this:Show();
	else
		this:Hide();
		return ;
	end	

	for i = 1, ACTIONBAR_NUM_BUTTONS do
		button = getglobal(this:GetName().."Button"..i);
		if ( i <= info.count ) then
			button.visible = true;
			button:Show();
			if ( i > 1 ) then
				button:ClearAllAnchors();
				if (  row < info.row) then
					row=row+1;
					button:SetAnchor("LEFT", "RIGHT", this:GetName().."Button"..(i - 1), ACTIONBUTTON_OFFSET, 0);			
				else
					row=1;
					button:SetAnchor("TOP", "BOTTOM", this:GetName().."Button"..info.row *(column-1)+1, 0, ACTIONBUTTON_OFFSET);				
					column=column+1;				
				end
			end
			
			ActionButton_Update(button);
			ActionButton_UpdateCooldown(button);
			ActionButton_UpdateHotkeys(button);
		else
			button.visible = false;
			button:Hide();
		end
	end
	
	local width = ACTIONBUTTON_SIZE * info.row + (info.row - 1) * ACTIONBUTTON_OFFSET;
	local height = ACTIONBUTTON_SIZE * column + (column - 1) * ACTIONBUTTON_OFFSET;
	this:SetSize(width, height);
end

function ExtraActionBarFrame_Update()
	local button, icon, hotkey;
	local count = 0, key;
	for i = 1, EXTRAACTIONBAR_NUM_BUTTONS do
		icon = GetExtraActionInfo(i);
		button = getglobal( "ExtraActionBarButton"..i );
		hotkey = getglobal( button:GetName().."Hotkey" );
		if( icon )then
			getglobal(button:GetName().."Icon"):SetTexture(icon);
			ExtraActionButton_UpdateCooldown(button);

			key = GetBindingKey( "EXTRAACTIONBUTTON" .. i );
			if ( key ) then
				hotkey:SetText(key);
			else
				hotkey:SetText("");
			end

			button:Show();
			count = i; 
		else
			button:Hide();
		end
	end

	if( count < 1 )then
		ExtraActionBarFrame:Hide();
		return;
	end

	--ExtraActionBarFrame:SetSize( 38 * count - 2 + 8 , 44 );
	ExtraActionBarFrame:SetSize( 36 * count, 36 );

end