-- ingame commandos
-- Reload this file:
--    /run dofile("interface/addons/arcadia/wowmap/wowmap_data.lua")
-- Fake all quest's to one map:
--   /run DEBUG_FORCE_QUEST_MAP=35; WoWMap.CollectQuestPOIs()

WoWMap.MapData = {
    --------------------------------------------------------------------------------------------------------------
    --	LinkTable:
    --		[ZoneID] =	{
    --			{x1, y1, x2, y2, ZoneID, "highlightname", scale, posX, posY},
    --			}
    --
    --		posX and posY are optional, when not given, midpoint of region is taken instead
    --		coordinates are ranged from 0 to 1, 0/0 is at the topleft corner, 1/1 at the bottomright of the map
    --------------------------------------------------------------------------------------------------------------
    LinkTable = {
        [1] = {
            -- Howling Mountain
            {0.440, 0.009, 0.588, 0.080, 2, "zone", 0.3}, -- Silverspring
            {0.670, 0.263, 0.700, 0.313, 101, "dungeon", 0.3, nil, nil, { 3, 7 } }, -- Cavern of Trials
            {0.236, 0.061, 0.276, 0.111, 110, "dungeon", 0.3, nil, nil, { 7, 10 }}, -- Barren Caves
            {0.680, 0.363, 0.720, 0.413, 118, "dungeon", 0.3, nil, nil, { 53, 55 }}, -- Cave of the Water Dragon
            {0.465, 0.425, 0.526, 0.488, 250, "dungeon", 0.3, nil, nil, { 14, 16 }}, -- Windmill Basement
            {0.352, 0.517, 0.437, 0.565, 301, "dungeon", 0.3, nil, nil, { 1, 2 }}, -- Fungus Garden
        },
        [2] = {
            -- Silverspring
            {0.264, 0.924, 0.401, 0.999, 1, "zone", 0.3}, -- Howling Mountains
            {0.710, 0.591, 0.795, 0.735, 3, "zone", 0.3}, -- Ravenfell
            {0.234, 0.111, 0.311, 0.257, 4, "zone", 0.3}, -- Aslan Valley
            {0.456, 0.000, 0.527, 0.048, 8, "zone", 0.3}, -- Savage Lands
            {0.307, 0.710, 0.345, 0.758, 102, "dungeon", 0.3, nil, nil, { 23, 26 }}, -- Forsaken Abbey
            {0.466, 0.059, 0.517, 0.118, 117, "dungeon", 0.3, nil, nil, { 54, 56, 98, 98 }}, -- Hall of Survivors
            {0.340, 0.280, 0.370, 0.320, 190, "dungeon", 0.3, nil, nil, { 65, 65 }}, -- Bolinthya Rift
            {0.298, 0.564, 0.395, 0.649, 201, "dungeon", 0.3, nil, nil, { 19, 24 }}, -- Bloody Gallery
            {0.298, 0.650, 0.346, 0.698, 356, "dungeon", 0.3, nil, nil, { 62, 62 }}, -- Ancient Dreamland
            {0.529, 0.784, 0.730, 0.943, 10000, "city", 2.0}, -- Varanas
        },
        [3] = {
            -- Ravenfell
            {0.054, 0.654, 0.124, 0.829, 2, "zone", 0.3}, -- Silverspring
            {0.368, 0.005, 0.571, 0.171, 7, "zone", 0.3}, -- Weeping Coast
            {0.375, 0.754, 0.423, 0.818, 108, "dungeon", 0.3, nil, nil, { 50, 52 }}, -- Treasure Trove
        },
        [4] = {
            -- Aslan Valley
            {0.781, 0.150, 0.853, 0.295, 2, "zone", 0.3}, -- Silverspring
            {0.365, 0.885, 0.422, 0.940, 5, "zone", 0.3}, -- Ystra Highlands
            {0.625, 0.852, 0.675, 0.916, 103, "dungeon", 0.3, nil, nil, { 35, 39 }}, -- Necropolis of Mirrors
            {0.210, 0.310, 0.311, 0.362, 116, "dungeon", 0.3, nil, nil, { 54, 56 }}, -- Origin
            {0.512, 0.614, 0.556, 0.665, 352, "dungeon", 0.3, nil, nil, { 50, GetPlayerMaxLevel() }}, -- Goblin Mine
        },
        [5] = {
            -- Ystra Highlands
            {0.614, 0.171, 0.727, 0.283, 4, "zone", 0.3, 0.639, 0.260}, -- Aslan Valley
            {0.384, 0.011, 0.542, 0.111, 6, "zone", 0.3, 0.411, 0.088}, -- Dust Devil Canyon
            {0.245, 0.629, 0.399, 0.755, 11, "zone", 0.3, 0.356, 0.641}, -- Dragonfang Ridge
            {0.504, 0.820, 0.541, 0.872, 104, "dungeon", 0.3, nil, nil, { 39, 43 }}, -- Mystic Altar
            {0.393, 0.514, 0.431, 0.562, 205, "dungeon", 0.3, nil, nil, { 31, 34 }}, -- Revivers' Corridor
            {0.481, 0.624, 0.524, 0.672, 206, "dungeon", 0.3, nil, nil, { 40, 43 }}, -- Guards' Corridor
            {0.289, 0.124, 0.327, 0.182, 207, "dungeon", 0.3, nil, nil, { 46, 50 }}, -- Royals' Refuge
        },
        [6] = {
            -- Dust Devil Canyon
            {0.515, 0.826, 0.706, 0.940, 5, "zone", 0.3, 0.600, 0.859}, -- Ystra Highlands
            {0.048, 0.733, 0.120, 0.879, 10, "zone", 0.3}, -- Sascilia Steppes
            {0.448, 0.564, 0.491, 0.624, 105, "dungeon", 0.3, nil, nil, { 52, 52 }}, -- Queen's Chamber
            {0.369, 0.313, 0.410, 0.360, 107, "dungeon", 0.3, nil, nil, { 52, 52, 104, 104 }}, -- Kalin Shrine
            {0.157, 0.880, 0.207, 0.945, 302, "dungeon", 0.3, nil, nil, { 45, GetPlayerMaxLevel() }}, -- Tempest Height
            {0.191, 0.666, 0.371, 0.808, 10001, "city", 2.0}, -- Obsidian Stronghold
        },
        [7] = {
            -- Weeping Coast
            {0.188, 0.914, 0.360, 0.993, 3, "zone", 0.3}, -- Ravenfell
            {0.078, 0.287, 0.138, 0.362, 8, "zone", 0.3}, -- Savage Lands
            {0.761, 0.646, 0.801, 0.692, 115, "dungeon", 0.3, nil, nil, { 50, 52, 104, 104  }}, -- Heart of the Ocean
        },
        [8] = {
            -- Savage Lands
            {0.596, 0.896, 0.662, 0.971, 2, "zone", 0.3}, -- Silverspring
            {0.792, 0.333, 0.958, 0.477, 7, "zone", 0.3, 0.822, 0.363}, -- Weeping Coast
            {0.256, 0.281, 0.335, 0.356, 9, "zone", 0.3, 0.295, 0.321}, -- Aotulia Vulcano
            {0.667, 0.896, 0.733, 0.971, 117, "dungeon", 0.3, nil, nil, { 53, 56, 98, 98 }}, -- Hall of Survivors
        },
        [9] = {
            -- Aotulia Vulcano
            {0.762, 0.738, 0.841, 0.813, 8, "zone", 0.3, 0.799, 0.780}, -- Savage Lands
            {0.301, 0.587, 0.350, 0.724, 119, "dungeon", 0.3, nil, nil, { 55, 55 }}, -- Lair of the Demon Dragon
            {0.288, 0.224, 0.330, 0.309, 120, "dungeon", 0.3, nil, nil, { 54, 57 }}, -- Zuridon Stronghold
            {0.283, 0.191, 0.412, 0.243, 122, "dungeon", 0.3, nil, nil, { 54, 57, 100, 102 }}, -- Hall of the Demon Lord
        },
        [10] = {
            -- Sascilia Steppes
            {0.807, 0.057, 0.970, 0.166, 6, "zone", 0.3}, -- Dust Devil Canyon
            {0.455, 0.920, 0.718, 0.991, 11, "zone", 0.3}, -- Dragonfang Ridge
            {0.099, 0.304, 0.152, 0.355, 106, "dungeon", 0.3, nil, nil, { 45, 47 }}, -- Pasper's Shrine
            {0.242, 0.503, 0.288, 0.554, 251, "dungeon", 0.3, nil, nil, { 14, 16 }}, -- Arcane Chamber of Sathkur
            {0.752, 0.147, 0.928, 0.333, 10001, "city", 2.0}, -- Obsidian Stronghold
        },
        [11] = {
            -- Dragonfang Ridge
            {0.946, 0.003, 0.999, 0.106, 5, "zone", 0.3}, -- Ystra Highlands
            {0.421, 0.200, 0.550, 0.248, 10, "zone", 0.3}, -- Sascilia Steppes
            {0.777, 0.731, 0.825, 0.828, 114, "dungeon", 0.3, nil, nil, { 35, 50, 105, 105 }}, -- Ruins of the Ice Dwarf Kingdom
            {0.119, 0.770, 0.187, 0.828, 133, "dungeon", 0.3, nil, nil, { 102, 102 }}, -- Secret Temple of Tikal
            {0.083, 0.166, 0.146, 0.218, 252, "dungeon", 0.3, nil, nil, { 50, 52, 98, 98 }}, -- Cyclops Lair
        },
        [13] = {
            -- Coast of Opportunity
            {0.495, 0.050, 0.665, 0.080, 14, "zone", 0.3}, -- Xaviera
        },
        [14] = {
            -- Xaviera
            {0.208, 0.362, 0.386, 0.466, 13, "zone", 0.3}, -- Coast of Opportunity
        },
        [15] = {
            -- Thunderhoof Hills
            {0.348, 0.021, 0.427, 0.106, 16, "zone", 0.3}, -- Southern Janost Forest
            {0.399, 0.086, 0.507, 0.135, 142, "dungeon", 0.3, nil, nil, { 70, 74 }}, -- Tomb of the Seven Heroes
            -- {0.556, 0.498, 0.600, 0.552, 209, "dungeon", 0.3}, -- Dalanis Sewers
            -- {0.514, 0.404, 0.556, 0.460, 401, "castle", 0.4}, -- Guild Castle
            {0.460, 0.340, 0.610, 0.550, 11002, "city", 1.7}, -- Dalanis
        },
        [16] = {
            -- Southern Janost Forest
            {0.086, 0.848, 0.278, 0.963, 15, "zone", 0.3}, -- Thunderhoof Hills
            {0.744, 0.066, 0.915, 0.270, 17, "zone", 0.3, 0.752, 0.263}, -- Northern Janost Forest
            {0.539, 0.623, 0.645, 0.762, 129, "dungeon", 0.3, nil, nil, { 57, 59 }}, -- Warnorken Arena
            {0.794, 0.675, 0.829, 0.746, 210, "dungeon", 0.3, nil, nil, { 57, 62 }}, -- Ruines of Magnork
        },
        [17] = {
            -- Northern Janost Forest
            {0.265, 0.871, 0.550, 0.980, 16, "zone", 0.3}, -- Southern Janost Forest
            {0.425, 0.015, 0.480, 0.080, 18, "zone", 0.3}, -- Limo Desert
            {0.128, 0.397, 0.175, 0.473, 130, "dungeon", 0.3, nil, nil, { 58, 62 }}, -- Raksha Temple
        },
        [18] = {
            -- Limo Desert
            {0.240, 0.890, 0.380, 0.970, 17, "zone", 0.3}, -- Northern Janost Forest
            {0.210, 0.310, 0.260, 0.360, 19, "zone", 0.3}, -- Land of Malevolance
            {0.255, 0.406, 0.310, 0.445, 134, "dungeon", 0.3, nil, nil, { 61, 63 }}, -- Kawak's Tomb
        },
        [19] = {
            -- Land of Malevolance
            {0.823, 0.174, 0.892, 0.277, 18, "zone", 0.3}, -- Limo Desert
            {0.212, 0.879, 0.272, 0.931, 20, "zone", 0.3}, -- Redhill Mountains
            {0.277, 0.749, 0.362, 0.790, 137, "dungeon", 0.3, nil, nil, { 65, 67 }}, -- Grafu Castle
        },
        [20] = {
            -- Redhill Mountains
            {0.575, 0.199, 0.646, 0.290, 19, "zone", 0.3}, -- Land of Malevolance
            {0.153, 0.815, 0.216, 0.975, 21, "zone", 0.3}, -- Tergothen Bay
            {0.230, 0.836, 0.304, 0.897, 139, "dungeon", 0.3}, -- Sardo Castle
            {0.192, 0.113, 0.372, 0.251, 80, "city", 1.5}, -- Fireboot Fortress
        },
        [21] = {
            -- Tergothen Bay
            {0.822, 0.022, 0.985, 0.210, 20, "zone", 0.3}, -- Redhill Mountains
            {0.808, 0.230, 0.883, 0.346, 139, "dungeon", 0.3, nil, nil, { 66, 68 }}, -- Sardo Castle
        },
        [22] = {
            -- Ancient Kingdom of Rorazan
            {0.768, 0.111, 0.840, 0.288, 23, "zone", 0.3}, -- Chrysalia
            {0.443, 0.163, 0.512, 0.211, 144, "dungeon", 0.3, nil, nil, { 72, 74 }}, -- Aeternal Circle
        },
        [23] = {
            -- Chrysalia
            {0.020, 0.390, 0.097, 0.554, 22, "zone", 0.3}, -- Ancient Kingdom of Rorazan
            {0.770, 0.150, 0.820, 0.230, 24, "zone", 0.3}, -- Merdhin Tundra
            {0.533, 0.657, 0.635, 0.709, 147, "dungeon", 0.3, nil, nil, { 75, 77 }}, -- Kulech Bones Nest
        },
        [24] = {
            -- Merdhin Tundra
            {0.060, 0.840, 0.150, 0.920, 23, "zone", 0.3}, -- Chrysalia
            {0.152, 0.177, 0.206, 0.417, 25, "zone", 0.3}, -- Syrbal Pass
            {0.513, 0.407, 0.628, 0.450, 149, "dungeon", 0.3, nil, nil, { 77, 80 }}, -- Castle of Bedim
        },
        [25] = {
            -- Syrbal Pass
            {0.720, 0.470, 0.790, 0.550, 24, "zone", 0.3}, -- Merdin Tundra
            {0.060, 0.222, 0.121, 0.282, 26, "zone", 0.3}, -- Sarlo
            {0.594, 0.168, 0.714, 0.212, 151, "dungeon", 0.3, nil, nil, { 80, 82 }}, -- Bethomia
        },
        [26] = {
            -- Sarlo
            {0.718, 0.107, 0.793, 0.273, 25, "zone", 0.3}, -- Syrbal Pass
            {0.456, 0.839, 0.499, 0.922, 155, "dungeon", 0.3, nil, nil, { 82, 85 }}, -- Belathis Fortress
        },
        [27] = {
            -- Wailing Fjord
            {0.51, 0.03, 0.59, 0.13, 28, "zone", 0.3}, -- Jungle of Hortek
            {0.350, 0.473, 0.395, 0.548, 158, "dungeon", 0.3, nil, nil, { 85, 87 }} -- Grotto of Horror
        },
        [28] = {
            -- Jungle of Hortek
            {0.338, 0.915, 0.553, 0.990, 27, "zone", 0.3}, -- Wailing Fjord
            {0.870, 0.212, 0.960, 0.423, 29, "zone", 0.3}, -- Salioca Basin
            {0.609, 0.351, 0.732, 0.400, 161, "dungeon", 0.3, nil, nil, { 87, 90 }}, -- The Pillars of Morfan
        },
        [29] = {
            -- Salioca Basin
            {0.020, 0.580, 0.050, 0.700, 28, "zone", 0.3}, -- Jungle of Hortek
            {0.494, 0.070, 0.669, 0.150, 30, "zone", 0.3}, -- Kashaylan
            {0.353, 0.793, 0.402, 0.857, 164, "dungeon", 0.3, nil, nil, { 90, 93 }}, -- Crypt of Eternity
        },
        [30] = {
            -- Kashaylan
            {0.55, 0.87, 0.74, 0.97, 29, "zone", 0.3}, -- Salioca Basin
            {0.751, 0.094, 0.806, 0.186, 167, "dungeon", 0.3, nil, nil, { 92, 95 }}, -- Veiled Crypt of Kashaylan
        },
        [31] = {
            -- Yrvandis Hollows
            {0.649, 0.135, 0.768, 0.204, 212, "dungeon", 0.3, nil, nil, { 9, 10 }}, -- Taffrock Southern District
        },
        [32] = {
            -- Splitwater Coast
            {0.530, 0.010, 0.750, 0.160, 33, "zone", 0.3}, -- Moorlands of Farsitan
            {0.642, 0.199, 0.717, 0.241, 170, "dungeon", 0.3, nil, nil, { 94, 96 }}, -- Bone Peak
        },
        [33] = {
            -- Moorlands of Farsitan
            {0.22, 0.860, 0.390, 0.980, 32, "zone", 0.3}, -- Splitwater Coast
            {0.221, 0.319, 0.310, 0.369, 173, "dungeon", 0.3, nil, nil, { 97, 98 }}, -- Madro Troll Nest
            {0.513, 0.713, 0.563, 0.792, 176, "dungeon", 0.3, nil, nil, { 97, 98 }}, -- Raven Heart
        },
        [34] = {
            -- Tasuq
            {0.232, 0.109, 0.349, 0.159, 179, "dungeon", 0.3, nil, nil, { 98, 99 }}, -- Vale of Rites
        },
        [35] = {
            -- Korris
            {0.103, 0.226, 0.226, 0.322, 182, "dungeon", 0.3, nil, nil, { 98, 100 }}, -- Ice Blade Plateau
        },
        [36] = {
            -- Enoch
            {0.478, 0.797, 0.524, 0.873, 185, "dungeon", 0.3, nil, nil, { 98, 100 }}, -- Sun Temple of Eternal Sleep
        },
        [37] = {
            -- Vortis
            {0.693, 0.248, 0.747, 0.292, 188, "dungeon", 0.3, nil, nil, { 99, 101 }}, -- Tomb of Souls
        },
        [38] = {
            -- Chassizz
            {0.786, 0.143, 0.853, 0.206, 255, "dungeon", 0.3, nil, nil, { 102, 104 }}, -- New Pantheon
            {0.686, 0.714, 0.734, 0.762, 257, "dungeon", 0.3, nil, nil, { 104, 105 }}, -- Entity Chamber
        },
        [90] = {
            -- Lost Island of Atlantis
            {0.482, 0.394, 0.528, 0.440, 964, "dungeon", 0.3, nil, nil, { 100, 102 }}, -- Dalanis Nightmare
            {0.535, 0.394, 0.581, 0.440, 974, "dungeon", 0.3, nil, nil, { 102, 104 }}, -- Chamber of Elements
            {0.404, 0.426, 0.448, 0.474, 976, "dungeon", 0.3, nil, nil, { 102, 104 }}, -- Atlas Defense
            {0.404, 0.475, 0.448, 0.518, 401, "castle", 0.3}, -- Guild Castle
        },
        [91] = {
            -- Talaghan
            {0.391, 0.214, 0.485, 0.316, 972, "dungeon", 0.3, 0.436, 0.314, { 105, 105 }}, -- Dark Core
            {0.880, 0.305, 0.910, 0.425, 977, "dungeon", 0.3, 0.900, 0.405, { 1, 105 }}, -- Arena of Darkness
            {0.281, 0.350, 0.355, 0.436, 978, "dungeon", 0.3, 0.336, 0.445, { 105, 105 }}, -- Orkham
            {0.600, 0.750, 0.750, 0.850, 10008, "zone", 0.3, 0.670, 0.800, { 105, 105 }}, -- Dark Valley
        },
        [205] = {
            -- Revivers' Corridor
            {0.074, 0.636, 0.184, 0.826, 5, "zone", 0.3}, -- Ystra Highlands
            {0.782, 0.047, 0.878, 0.151, 206, "dungeon", 0.3, nil, nil, { 40, 43 }}, -- Guards' Corridor
        },
        [206] = {
            -- Guards' Corridor
            {0.488, 0.553, 0.594, 0.698, 5, "zone", 0.3}, -- Ystra Highlands
            {0.488, 0.711, 0.594, 0.809, 205, "dungeon", 0.3, nil, nil, { 31, 34 }}, -- Revivers' Corridor
            {0.858, 0.425, 0.956, 0.539, 207, "dungeon", 0.3, nil, nil, { 46, 50 }}, -- Royals' Refuge
        },
        [207] = {
            -- Royals' Refuge
            {0.654, 0.747, 0.736, 0.868, 5, "zone", 0.3}, -- Ystra Highlands
            {0.654, 0.883, 0.736, 0.971, 206, "dungeon", 0.3, nil, nil, { 40, 43 }}, -- Guards' Corridor
        },
        [209] = {
            -- Dalanis Sewers
            {0.275, 0.076, 0.366, 0.173, 11002, "zone", 0.3}, -- Dalanis
            {0.508, 0.859, 0.554, 0.906, 127, "dungeon", 0.3, nil, nil, { 56, 58 }}, -- Dungeon of Dalanis
        },
        [974] = {
            -- Chamber of Elements
            {0.700, 0.300, 0.746, 0.346, 968, "dungeon", 0.3, nil, nil, { 103, 104 }}, -- Inferno of Divinity
            {0.560, 0.690, 0.606, 0.736, 969, "dungeon", 0.3, nil, nil, { 104, 104 }}, -- Gorge of the Ice Giants
            {0.410, 0.550, 0.450, 0.590, 971, "dungeon", 0.3, nil, nil, { 104, 104 }}, -- Realm of Forgotten Legends
        },
		[9993] = {
            -- Isles
            {0.098, 0.438, 0.231, 0.592, 34, "zone34", 1.5, nil, nil, { 98, 98 } }, -- Tasuq
            {0.259, 0.201, 0.469, 0.441, 35, "zone35", 1.6, nil, nil, { 99, 99 } }, -- Korris
            {0.515, 0.123, 0.658, 0.313, 36, "zone36", 2.3, nil, nil, { 100, 100 } }, -- Enoch
            {0.416, 0.476, 0.572, 0.711, 37, "zone37", 2.0, nil, nil, { 100, 100 } }, -- Vortis
            {0.618, 0.273, 0.864, 0.592, 38, "zone38", 2.9, nil, nil, { 100, 100 } }, -- Chassizz
			{0.590, 0.620, 0.769, 0.898, 90, "zone90", 2.5, nil, nil, { 102, 104 } }, -- Lost Island of Atlantis
        },
        [9994] = {
            -- Kolydia
            {0.356, 0.474, 0.634, 0.778, 32, "zone32", 2.7, nil, nil, { 93, 95 } }, -- Splitwater Coast
            {0.431, 0.269, 0.670, 0.494, 33, "zone33", 1.9, nil, nil, { 95, 97 } }, -- Moorlands of Farsitan
        },
        [9995] = {
            -- Gerador
            {0.286, 0.520, 0.374, 0.795, 27, "zone27", 2.1, 0.390, 0.659, { 83, 87 }}, -- Wailing Fjord (1/2)
            {0.286, 0.570, 0.500, 0.795, 27, "zone27", 2.1, 0.390, 0.659, { 83, 87 }}, -- Wailing Fjord (2/2)
            {0.375, 0.340, 0.540, 0.566, 28, "zone28", 1.8, nil, nil, { 86, 89 } }, -- Jungle of Hortek
            {0.550, 0.280, 0.720, 0.477, 29, "zone29", 2.0, nil, nil, { 89, 92 } }, -- Salioca Basin
            {0.560, 0.087, 0.710, 0.280, 30, "zone30", 1.7, nil, nil, { 92, 95 } }, -- Kashaylan
        },
        [9996] = {
            -- Balanzasar
            {0.310, 0.502, 0.510, 0.724, 22, "zone22", 2.15, nil, nil, { 70, 73 } }, -- Ancient Kingdom of Rorazan
            {0.480, 0.438, 0.657, 0.635, 23, "zone23", 2.3, 0.560, 0.539, { 72, 75 }}, -- Chrysalia
            {0.640, 0.265, 0.800, 0.550, 24, "zone24", 2.3, nil, nil, { 75, 77 } }, -- Merdhin Tundra
            {0.505, 0.225, 0.650, 0.415, 25, "zone25", 2.3, nil, nil, { 77, 79 } }, -- Syrbal Pass
            {0.300, 0.190, 0.507, 0.480, 26, "zone26", 2.3, nil, nil, { 79, 82 } }, -- Sarlo
            {0.174, 0.490, 0.267, 0.579, 31, "city", 0.6, nil, nil, { 1, 11 } }, -- Yrvandis Hollows
        },
        [9997] = {
            -- Zandorya
            {0.505, 0.715, 0.695, 0.905, 15, "zone15", 2.1, nil, nil, { 56, 57 } }, -- Thunderhoof Hills
            {0.540, 0.545, 0.705, 0.705, 16, "zone16", 2.0, nil, nil, { 57, 58 } }, -- Southern Janost Forest
            {0.585, 0.415, 0.750, 0.535, 17, "zone17", 1.9, nil, nil, { 58, 60 } }, -- Northern Janost Forest
            {0.632, 0.195, 0.785, 0.405, 18, "zone18", 1.8, nil, nil, { 60, 62 } }, -- Limo Desert
            {0.525, 0.125, 0.655, 0.280, 19, "zone19", 1.5, nil, nil, { 63, 66 } }, -- Land of Malevolence
            {0.475, 0.285, 0.595, 0.445, 20, "zone20", 1.7, nil, nil, { 64, 67 } }, -- Redhill Mountains
            {0.237, 0.326, 0.470, 0.592, 21, "zone21", 1.8, nil, nil, { 67, 71 } }, -- Tergothen Bay
        },
        [9998] = {
            -- Candara
            {0.468, 0.552, 0.560, 0.736, 1, "zone1", 1.5, nil, nil, { 1, 11 } }, -- Howling Mountains
            {0.507, 0.377, 0.598, 0.559, 2, "zone2", 1.6, nil, nil, { 10, 20 } }, -- Silverspring
            {0.620, 0.372, 0.755, 0.540, 3, "zone3", 1.7, nil, nil, { 43, 47 } }, -- Ravenfell
            {0.425, 0.404, 0.510, 0.551, 4, "zone4", 1.4, nil, nil, { 21, 27 } }, -- Aslan Valley
            {0.293, 0.528, 0.450, 0.702, 5, "zone5", 1.7, nil, nil, { 27, 34 } }, -- Ystra Highlands
            {0.278, 0.299, 0.441, 0.513, 6, "zone6", 1.9, nil, nil, { 35, 43 } }, -- Dust Devil Canyon
            {0.646, 0.149, 0.817, 0.367, 7, "zone7", 2.3, nil, nil, { 50, 52 } }, -- Weeping Coast
            {0.459, 0.127, 0.612, 0.367, 8, "zone8", 2.1, nil, nil, { 53, 55 } }, -- Savage Lands
            {0.247, 0.049, 0.453, 0.294, 9, "zone9", 2.4, nil, nil, { 55, 55 } }, -- Aotulia Vulcano
            {0.080, 0.425, 0.269, 0.688, 10, "zone10", 2.3, nil, nil, { 5, 45 } }, -- Sascilia Steppes
            {0.089, 0.680, 0.371, 0.864, 11, "zone11", 2.5, nil, nil, { 34, 50 } }, -- Dragonfang Ridge
            {0.835, 0.450, 0.911, 0.551, 12, "zone12", 1.3, nil, nil, { 1, 13 } }, -- Elven Island
            {0.685, 0.703, 0.817, 0.904, 13, "zone13", 1.6, nil, nil, { 1, 40 } }, -- Coast of Opportunity
            {0.797, 0.672, 0.913, 0.853, 14, "zone14", 1.7, nil, nil, { 40, 50 } }, -- Xaviera
            {0.552, 0.535, 0.602, 0.598, 10000, "city", 0.7, nil, nil, { 10, 30 } }, -- Varanas
            {0.274, 0.459, 0.335, 0.520, 10001, "city", 0.8, nil, nil, { 35, 43 } }, -- Obsidian Stronghold
        },
        [9999] = {
            -- Taborea
            {0.098, 0.522, 0.505, 0.946, 9998, "continent-candara", 3.74, 0.301, 0.729, { 1, 55 } }, -- Candara
            {0.040, 0.080, 0.270, 0.442, 9997, "continent-zandorya", 2.8, 0.158, 0.267, { 56, 71 } }, -- Zandorya
            {0.602, 0.060, 0.947, 0.380, 9996, "continent-balanzasar", 3.26, 0.769, 0.207, { 70, 82 } }, -- Balanzasar
            {0.354, 0.018, 0.550, 0.323, 9995, "continent-gerador", 1.83, nil, nil, { 83, 95 } }, -- Gerador
            {0.577, 0.729, 0.688, 0.901, 9994, "continent-kolydia", 1.7, nil, nil, { 93, 97 } }, -- Kolydia
            {0.344, 0.322, 0.582, 0.591, 9993, "continent-isles", 2.4, nil, nil, { 98, 104 } }, -- Isles
            {0.663, 0.567, 0.800, 0.711, 91, "zone91", 1.5, nil, nil, { 104, 105 } }, -- Talaghan
        },
        [10000] = {
            -- Varanas
            {0.400, 0.360, 0.430, 0.390, 194, "dungeon", 0.2, nil, nil, { 80, 80 }}, -- Chaos Vortex: Evil
            {0.231, 0.299, 0.328, 0.353, 208, "dungeon", 0.2, nil, nil, { 62, 62 }}, -- Varanas Nightmare
            {0.450, 0.643, 0.474, 0.667, 196, "dungeon", 0.2, nil, nil, { 87, 87 }}, -- Hall of Earth
            {0.475, 0.643, 0.499, 0.667, 197, "dungeon", 0.2, nil, nil, { 90, 90 }}, -- Hall of Water
            {0.450, 0.668, 0.474, 0.692, 198, "dungeon", 0.2, nil, nil, { 92, 92 }}, -- Hall of Fire
            {0.475, 0.668, 0.499, 0.692, 199, "dungeon", 0.2, nil, nil, { 95, 95 }}, -- Hall of Chaos
            {0.205, 0.443, 0.269, 0.510, 401, "castle", 0.4}, -- Guild Castle
            {0.519, 0.147, 0.577, 0.227, 401, "castle", 0.4}, -- Guild Castle
        },
        [10001] = {
            -- Obsidian Stronghold
            {0.515, 0.166, 0.575, 0.244, 401, "castle", 0.4}, -- Guild Castle
        },
        [11002] = {
            -- Dalanis
            {0.780, 0.435, 0.805, 0.470, 209, "dungeon", 0.2, nil, nil, { 56, 57 }}, -- Dalanis Sewers
            {0.550, 0.340, 0.585, 0.375, 401, "castle", 0.4}, -- Guild Castle
        },
    },
    --------------------------------------------------------------------------------------------------------------
    --	ZoomOutTable: [ZoneID] = Zoom to ZoneID,
    --------------------------------------------------------------------------------------------------------------
    ZoomOutTable = {
        [1] = 9998, -- Howling Mountains
        [2] = 9998, -- Silverspring
        [3] = 9998, -- Ravenfell
        [4] = 9998, -- Aslan Valley
        [5] = 9998, -- Ystra Highlands
        [6] = 9998, -- Dust Devil Canyon
        [7] = 9998, -- Weeping Coast
        [8] = 9998, -- Savage Lands
        [9] = 9998, -- Aotulia Vulcano
        [10] = 9998, -- Sascilia Steppes
        [11] = 9998, -- Dragonfang Ridge
        [12] = 9998, -- Elven Island
        [13] = 9998, -- Coast of Opportunity
        [14] = 9998, -- Xaviera
        [15] = 9997, -- Thunderhoof Hills
        [16] = 9997, -- Southern Janost Forest
        [17] = 9997, -- Northern Janost Forest
        [18] = 9997, -- Limo Desert
        [19] = 9997, -- Land of Malevolence
        [20] = 9997, -- Redhill Mountains
        [21] = 9997, -- Tergothen Bay
        [22] = 9996, -- Ancient Kingdom of Rorazan
        [23] = 9996, -- Chrysalia
        [24] = 9996, -- Merdin Tundra
        [25] = 9996, -- Syrbal Pass
        [26] = 9996, -- Sarlo
        [27] = 9995, -- Wailing Fjord
        [28] = 9995, -- Jungle of Hortek
        [29] = 9995, -- Salioca Basin
        [30] = 9995, -- Kashaylan
        [31] = 9996, -- Yrvandis Hollows
        [32] = 9994, -- Splitwater Coast
        [33] = 9994, -- Moorlands of Farsitan
        [34] = 9993, -- Tasuq
        [35] = 9993, -- Korris
        [36] = 9993, -- Enoch
        [37] = 9993, -- Vortis
        [38] = 9993, -- Chassizz
        [80] = 20, -- Fireboot Fortress
        [81] = 10000, -- Arcanium Arena
        [90] = 9993, -- Lost Island of Atlantis
        [91] = 9992, -- Talaghan
        [100] = 9999, -- Tutorial
        [101] = 1, -- Cavern of Trials
        [102] = 2, -- Forsaken Abbey
        [103] = 4, -- Necropolis of Mirrors
        [104] = 5, -- Mystic Altar
        [105] = 6, -- Queen's Chamber
        [106] = 10, -- Pasper's Shrine
        [107] = 6, -- Kalin Shrine
        [108] = 3, -- Treasure Trove
        -- [109] = 206 -- Ystra Labirynth: Troublemaker
        [110] = 1, -- Barren Caves
        -- [111] = 207, - Ystra Labirynth: Ancient Rune Technology
        -- [112] = 207, -- Ystra Labirynth: A Sudden Setback
        [113] = 11, -- Ruins of the Ice Dwarf Kingdom
        [114] = 11, -- Ruins of the Ice Dwarf Kingdom
        [115] = 7, -- Heart of the Ocean
        [116] = 4, -- Origin
        [117] = 2, -- Hall of Survivors
        [118] = 1, -- Cave of the Water Dragon
        [119] = 9, -- Lair of the Demon Dragon
        [120] = 9, -- Zuridon Stronghold
        [122] = 9, -- Hall of the Demon Lord
        [123] = 2, -- Hall of Survivors
        [126] = 7, -- Heart of the Ocean
        [127] = 209, -- Dungeon of Dalanis
        [128] = 209, -- Dungeon of Dalanis
        [129] = 16, -- Warnorken Arena
        [130] = 17, -- Raksha Temple
        [131] = 16, -- Warnorken Arena
        [132] = 17, -- Raksha Temple
        [133] = 11, -- Secret Temple of Tikal
        [134] = 18, -- Kawak's Tomb
        [135] = 18, -- Kawak's Tomb
        [136] = 19, -- Castle Grafu
        [137] = 19, -- Castle Grafu
        [138] = 19, -- Castle Grafu
        [139] = 20, -- Castle Sardo
        [140] = 20, -- Castle Sardo
        [141] = 15, -- Tomb of the Seven Heroes
        [142] = 15, -- Tomb of the Seven Heroes
        [143] = 15, -- Tomb of the Seven Heroes
        [144] = 22, -- Aeternal Circle
        [145] = 22, -- Aeternal Circle
        [146] = 23, -- Kulech Bones Nest
        [147] = 23, -- Kulech Bones Nest
        [148] = 23, -- Kulech Bones Nest
        [149] = 24, -- Bedim Castle
        [150] = 24, -- Bedim Castle
        [151] = 25, -- Bethomia
        [152] = 25, -- Bethomia
        [153] = 25, -- Bethomia
        [154] = 26, -- Belathis Fortress
        [155] = 26, -- Belathis Fortress
        [156] = 26, -- Belathis Fortress
        [157] = 27, -- Grotto of Horror
        [158] = 27, -- Grotto of Horror
        [159] = 27, -- Grotto of Horror
        [160] = 28, -- The Pillars of Morfan
        [161] = 28, -- The Pillars of Morfan
        [162] = 28, -- The Pillars of Morfan
        [163] = 29, -- Crypt of Eternity
        [164] = 29, -- Crypt of Eternity
        [165] = 29, -- Crypt of Eternity
        [166] = 30, -- Veiled Crypt of Kashaylan
        [167] = 30, -- Veiled Crypt of Kashaylan
        [168] = 30, -- Veiled Crypt of Kashaylan
        [169] = 32, -- Bone Peak
        [170] = 32, -- Bone Peak
        [171] = 32, -- Bone Peak
        [172] = 33, -- Madro Troll Nest
        [173] = 33, -- Madro Troll Nest
        [174] = 33, -- Madro Troll Nest
        [175] = 33, -- Raven Heart
        [176] = 33, -- Raven Heart
        [177] = 33, -- Raven Heart
        [178] = 34, -- Vale of Rites
        [179] = 34, -- Vale of Rites
        [180] = 34, -- Vale of Rites
        [181] = 35, -- Ice Blade Plateau
        [182] = 35, -- Ice Blade Plateau
        [183] = 35, -- Ice Blade Plateau
        [184] = 36, -- Sun Temple of Eternal Sleep
        [185] = 36, -- Sun Temple of Eternal Sleep
        [186] = 36, -- Sun Temple of Eternal Sleep
        [187] = 37, -- Tomb of Souls
        [188] = 37, -- Tomb of Souls
        [189] = 37, -- Tomb of Souls
        [190] = 2, -- Bolinthya Rift
        [191] = 9998, -- Osalon Valley
        [194] = 10000, -- Chaos Vortex: Evil
        [196] = 10000, -- Hall of Earth
        [197] = 10000, -- Hall of Water
        [198] = 10000, -- Hall of Fire
        [199] = 10000, -- Hall of Chaos
        [201] = 2, -- Bloody Gallery
        [202] = 5, -- Revivers' Corridor
        [203] = 5, -- Guards' Corridor
        [204] = 5, -- Royals' Refuge
        [205] = 5, -- Revivers' Corridor
        [206] = 5, -- Guards' Corridor
        [207] = 5, -- Royals' Refuge
        [208] = 10000, -- Varanas Nightmare
        [209] = 11002, -- Dalanis Sewers
        [210] = 16, -- Ruines of Magnork
        [211] = 20, -- Fireboot Fortress
        [212] = 31, -- Taffrock Southern District
        [250] = 1, -- Windmill Basement
        [251] = 10, -- Arcane Chamber of Sathkur
        [252] = 11, -- Cyclops Lair
        [254] = 38, -- New Pantheon
        [255] = 38, -- New Pantheon
        [256] = 38, -- New Pantheon
        [257] = 38, -- Entity Chamber
        [301] = 1, -- Fungus Garden
        [302] = 6, -- Tempest Height
        [303] = 10000, -- Wedding Hall
        [304] = 9999, -- Miller's Ranch
        [350] = 10000, -- Windrunner Race
        [351] = 10000, -- Malatina's Dungeon
        [352] = 4, -- Goblin Mines
        [353] = 10000, -- Malatina's Course of Terror
        [355] = 2, -- Ancient Treasure Hunt
        [356] = 2, -- Ancient Dreamland
        [357] = 2, -- Secret Garden
        [358] = 9998, -- Ystra Highlands (Event)
        [400] = 9999, -- Residence
        [401] = 9999, -- Guild Castle
        [402] = 9999, -- Guild Castle
        [410] = 10001, -- 1vs1 Arena
        [411] = 10001, -- 6vs6 Arena
        [430] = 10001, -- 3vs3 Arena
        [431] = 10001, -- Karros Canyon
        [432] = 10001, -- Visdun Fortress
        [440] = 10001, -- 1vs1 Arena
        [441] = 10000, -- Windrunner Race
        [442] = 10001, -- 3vs3 Arena
        [443] = 10001, -- 6vs6 Arena
        [444] = 10001, -- Karros Canyon
        [445] = 10001, -- Visdun Fortress
        [446] = 10001, -- Tyrefen Mountain Range
        [450] = 10001, -- Vermillia Basin
        [958] = 6, -- Kalin Shrine
        [959] = 1, -- Cave of the Water Dragon
        [960] = 7, -- Heart of the Ocean
        [961] = 9, -- Hall of the Demon Lord
        [962] = 11, -- Cyclops Lair
        [963] = 1, -- Hall of Survivors
        [964] = 90, -- Dalanis Nightmare
        [965] = 90, -- Garden of Eden
        [968] = 974, -- Inferno of Divinity
        [969] = 974, -- George of the Ice Giants
        [970] = 974, -- Realm of Forgotten Legends
        [971] = 974, -- Realm of Forgotten Legends
        [972] = 91, -- Dark Core
        [973] = 90, -- Celebria
        [974] = 90, -- Chamber of Elements
        [975] = 973, -- Boss Spawn
        [976] = 90, -- Atlas Defense
        [977] = 91, -- Arena of Darkness
        [978] = 91, -- Orkham
        [9993] = 9999, -- Isles
        [9994] = 9999, -- Kolydia
        [9995] = 9999, -- Gerador
        [9996] = 9999, -- Balanzasar
        [9997] = 9999, -- Zandorya
        [9998] = 9999, -- Candara
        [9999] = 9999, -- Taborea
        [10000] = 2, -- Varanas
        [10001] = 6, -- Obsidian Stronghold
        [10002] = 22, -- Aeternal Circle
        [10003] = 22, -- Aeternal Circle
        [10004] = 22, -- Aeternal Circle
        [10005] = 22, -- Aeternal Circle
        [10006] = 22, -- Aeternal Circle
        [10008] = 91, -- Dark Valley
        [10007] = 155, -- Belathis
        [11002] = 15, -- Dalanis
    },
    --------------------------------------------------------------------------------------------------------------
    -- CustomMaps
    --		This is for custom sub/city maps
    --      -> kind = see g_MapTypes in worldmap.lua (0=world(!), 1=zone,2=city,..)
    --      -> coords_transpose = is used to calculate player position & Quest Icons
    --                            [real_map] = {x1,y1,x2,y2}
    --------------------------------------------------------------------------------------------------------------
    CustomMaps = {
        maps = {
            [9993] = {
                dir = "Isles",
                name = TEXT("ZONE_ISLES"),
                kind = 0,
                coords_transpose = {
                    [34] = {0.098, 0.438, 0.231, 0.592},
                    [35] = {0.259, 0.201, 0.469, 0.441},
                    [36] = {0.516, 0.123, 0.661, 0.315},
                    [37] = {0.425, 0.476, 0.578, 0.711},
                    [38] = {0.641, 0.285, 0.854, 0.594},
                    [90] = {0.617, 0.655, 0.746, 0.836},
                },
            },
            [9994] = {
                dir = "Kolydia",
                name = TEXT("ZONE_KOLYDIA"),
                kind = 0,
                coords_transpose = {
                    [32] = {0.356, 0.474, 0.634, 0.758},
                    [33] = {0.431, 0.269, 0.670, 0.494},
                },
            },
            [9995] = {
                dir = "Gerador",
                name = TEXT("SC_GDDR_00"),
                kind = 0,
                coords_transpose = {
                    [27] = {0.286, 0.540, 0.560, 0.795},
                    [28] = {0.325, 0.325, 0.565, 0.570},
                    [29] = {0.520, 0.265, 0.775, 0.510},
                    [30] = {0.535, 0.080, 0.740, 0.300},
                },
            },
            [9996] = {
                dir = "Balanzasar",
                name = TEXT("SC_BALANZASAR"),
                kind = 0,
                coords_transpose = {
                    [22] = {0.327, 0.502, 0.530, 0.731},
                    [23] = {0.470, 0.405, 0.710, 0.665},
                    [24] = {0.629, 0.237, 0.880, 0.550},
                    [25] = {0.470, 0.180, 0.725, 0.455},
                    [26] = {0.280, 0.190, 0.550, 0.490},
                    [31] = {0.191, 0.521, 0.254, 0.569},
                },
            },
            [9997] = {
                dir = "Zandorya",
                name = TEXT("ZONE_SAVILLEPLAINS"),
                kind = 0,
                coords_transpose = {
                    [15] = {0.505, 0.715, 0.695, 0.905},
                    [16] = {0.540, 0.545, 0.705, 0.705},
                    [17] = {0.585, 0.415, 0.750, 0.535},
                    [18] = {0.632, 0.195, 0.785, 0.405},
                    [19] = {0.525, 0.125, 0.655, 0.280},
                    [20] = {0.475, 0.285, 0.595, 0.445},
                    [21] = {0.237, 0.326, 0.470, 0.592},
                },
            },
            [9998] = {
                dir = "Candara",
                name = TEXT("ZONE_YGGNO LAND"),
                kind = 0,
                coords_transpose = {
                    [1] = {0.460, 0.550, 0.580, 0.744},
                    [2] = {0.485, 0.370, 0.617, 0.556},
                    [3] = {0.596, 0.348, 0.783, 0.570},
                    [4] = {0.397, 0.385, 0.526, 0.565},
                    [5] = {0.284, 0.514, 0.468, 0.706},
                    [6] = {0.264, 0.275, 0.458, 0.538},
                    [7] = {0.616, 0.120, 0.838, 0.373},
                    [8] = {0.430, 0.105, 0.640, 0.373},
                    [9] = {0.211, 0.001, 0.464, 0.297},
                    [10] = {0.021, 0.410, 0.310, 0.715},
                    [11] = {0.080, 0.680, 0.340, 0.890},
                    [12] = {0.823, 0.428, 0.933, 0.574},
                    [13] = {0.695, 0.703, 0.837, 0.904},
                    [14] = {0.777, 0.672, 0.903, 0.853},
                    [10001] = {0.266, 0.442, 0.333, 0.528},
                    [11002] = {0.550, 0.531, 0.601, 0.601},
                },
            },
            [9999] = {
                dir = "Taborea",
                name = TEXT("ZONE_WORLD MAP"),
                kind = -1,
                coords_transpose = {
                    -- Candara
                    [1] = {0.298, 0.753, 0.356, 0.836},
                    [2] = {0.320, 0.665, 0.370, 0.750},
                    [3] = {0.366, 0.665, 0.427, 0.758},
                    [4] = {0.271, 0.680, 0.322, 0.760},
                    [5] = {0.223, 0.737, 0.298, 0.822},
                    [6] = {0.215, 0.644, 0.288, 0.741},
                    [7] = {0.373, 0.575, 0.464, 0.670},
                    [8] = {0.296, 0.562, 0.370, 0.674},
                    [9] = {0.183, 0.522, 0.281, 0.642},
                    [10] = {0.124, 0.695, 0.225, 0.810},
                    [11] = {0.131, 0.804, 0.251, 0.907},
                    [12] = {0.455, 0.703, 0.504, 0.761},
                    [13] = {0.360, 0.792, 0.470, 0.927},
                    [14] = {0.410, 0.800, 0.490, 0.896},
                    -- Zandorya
                    [15] = {0.137, 0.350, 0.244, 0.450},
                    [16] = {0.157, 0.292, 0.232, 0.357},
                    [17] = {0.183, 0.231, 0.260, 0.296},
                    [18] = {0.204, 0.120, 0.278, 0.233},
                    [19] = {0.152, 0.100, 0.214, 0.160},
                    [20] = {0.118, 0.163, 0.200, 0.243},
                    [21] = {0.041, 0.191, 0.122, 0.313},
                    -- Balanzasar
                    [22] = {0.679, 0.255, 0.790, 0.361},
                    [23] = {0.768, 0.205, 0.868, 0.335},
                    [24] = {0.850, 0.113, 0.961, 0.268},
                    [25] = {0.763, 0.079, 0.893, 0.207},
                    [26] = {0.673, 0.075, 0.790, 0.235},
                    [31] = {0.604, 0.242, 0.640, 0.277},
                    -- Gerador
                    [27] = {0.384, 0.220, 0.460, 0.300},
                    [28] = {0.387, 0.139, 0.462, 0.225},
                    [29] = {0.462, 0.138, 0.530, 0.203},
                    [30] = {0.455, 0.056, 0.522, 0.139},
                    -- Kolydia
                    [32] = {0.577, 0.805, 0.675, 0.912},
                    [33] = {0.609, 0.720, 0.689, 0.817},
                    -- Isles
                    [34] = {0.335, 0.442, 0.388, 0.488},
                    [35] = {0.397, 0.370, 0.455, 0.435},
                    [36] = {0.471, 0.340, 0.515, 0.399},
                    [37] = {0.446, 0.454, 0.490, 0.522},
                    [38] = {0.516, 0.393, 0.442, 0.482},
                    [90] = {0.493, 0.513, 0.547, 0.584},
                    -- Talaghan
                    [91] = {0.663, 0.567, 0.800, 0.711},
                },
            },
            [11002] = {
                dir = "Dalanis",
                name = TEXT("ZONE_DAELANIS"),
                kind = 2,
                coords_transpose = {
                    [15] = {-1.4947, -1.4929, 2.3574, 2.507},
                },
            },
        },
        --------------------------------------------------------------------------------------------------------------
        --		"parents" defines sub-zones.
        --      This is used to test if a player is in one of our custome subzones
        --        [real_map_id] = { [sub_zone_id]={x1,y1,x2,y2}, ....}
        --------------------------------------------------------------------------------------------------------------
        parents = {
            [15] = {
				[11002] = {0.467, 0.404, 0.610, 0.581},
			},
        },
    }
}