--[[
[guid]={[id,num,rate]*100}
]]
local GetTreasureData = function(id)
	local guid = GetObjectInfo(id,"guid")
	if not guid then return end
	
	local count = GetObjectInfo(id,"itemcount")
	local treasures = {}
	if not count or count == 0 then return end
	for i = 1, count do
		local treasureitem = GetObjectInfo(id,"treasureitem"..i)
		local treasurecount = GetObjectInfo(id,"treasurecount"..i)
		local treasuredropcount = GetObjectInfo(id,"treasuredropcount"..i)
		table.insert(treasures,treasureitem)
		table.insert(treasures,treasurecount)
		table.insert(treasures,treasuredropcount)
	end
	return treasures
end
local dbTable = { -- hos/cl hard mode drops
	[720074999] ={239034,20000,1,239045,20000,1,239056,20000,1,239023,20000,1,239012,20000,1,223509,16666,1,222950,20000,20000,211515,10000,1,211515,0,1},
	[720275999] ={219429,7700,1,219430,7700,1,219431,7700,1,219432,7700,1,219433,7700,1,219434,7700,1,219435,7700,1,219436,7700,1,219437,7700,1,219438,7700,1,219439,7700,1,219440,7700,1,219441,7700,1},
	[724242999] ={239035,20000,1,239036,20000,1,239024,20000,1,239011,20000,1,239016,20000,1,223519,0,0,239011,20000,20000,239016,20000,1,223519,0,0,223519,0,0,223519,0,0,223519,0,0},
	[724243999] ={239033,12500,1,239047,12500,1,239055,12500,1,239025,12500,1,239022,12500,1,239013,12500,1,239014,12500,1,239015,12500,1},
	[724246999] ={239046,20000,1,239044,20000,1,239057,20000,1,239058,20000,1,239017,20000,1},
	[727905999] ={1243897,10000,3,1243897,25000,2,1243897,65000,1},
	[727906999] ={1243897,10000,7,1243897,25000,4,1243897,65000,2},
	[727907999] ={1243897,100000,7},
	[727908999] ={219458,6666,1,219459,6666,1,219460,6666,1,219461,6666,1,219462,6666,1,219463,6666,1,219464,6676,1,219465,6666,1,219466,6666,1,219467,6666,1,219468,6666,1,219469,6666,1,219470,6666,1},
	[727909999] ={219445,6666,1,219446,6666,1,219447,6666,1,219448,6666,1,219449,6666,1,219450,6666,1,219451,6676,1,219452,6666,1,219453,6666,1,219454,6666,1,219455,6666,1,219456,6666,1,219457,6666,1},
	[727910999] ={1243899,30000,1,1243898,55000,1,1243898,15000,5},
	[799090999] ={1243992,100000,900},
}

local starting, ending = 720000, 800000
for i = starting, ending do 
	local treasure = GetTreasureData(i)
	if treasure then
		dbTable[i] = treasure
		dbTable[i].name = string.lower(TEXT(("Sys%d_name"):format(i)))
	end
end

return dbTable
