--[[
[guid]={pos,level, {[statid, statrate]*6}}
]]
local GetArmorData = function(id)
	local guid = GetObjectInfo(id,"guid")
	if not guid then return end
	
	local armorpos = GetObjectInfo(id,"armorpos")
	local limitlv = GetObjectInfo(id,"limitlv")
	local dropabilities = {}
	for i = 1, 6 do
		local dropability = GetObjectInfo(id,"dropability"..i)
		local dropabilityrate = GetObjectInfo(id,"dropabilityrate"..i)
		if dropability ~= 0 then
			table.insert(dropabilities,dropability)
			table.insert(dropabilities,dropabilityrate)
		end
	end
	return { armorpos, limitlv, dropabilities[1], dropabilities[2], dropabilities[3], dropabilities[4], dropabilities[5], dropabilities[6] }
end

local dbTable = {}

local starting, ending = 220000, 240000

for id = starting, ending do
	local armor = GetArmorData(id)
	if armor then
		dbTable[id] = armor
		dbTable[id].name = string.lower(TEXT(("Sys%d_name"):format(id)))
	end
end

return dbTable
