--[[
[guid]={pos,level, {[statid, statrate]*6}}
]]
local GetWeaponData = function(id)
	local guid = GetObjectInfo(id,"guid")
	if not guid then return end
	
	local weaponpos = GetObjectInfo(id,"weaponpos")
	local limitlv = GetObjectInfo(id,"limitlv")
	local dropabilities = {}
	for i = 1, 6 do
		local dropability = GetObjectInfo(id,"dropability"..i)
		local dropabilityrate = GetObjectInfo(id,"dropabilityrate"..i)
		if dropability ~= 0 then
			table.insert(dropabilities,dropability)
			table.insert(dropabilities,dropabilityrate)
		end
	end
	return { weaponpos, limitlv, dropabilities[1], dropabilities[2], dropabilities[3], dropabilities[4], dropabilities[5], dropabilities[6] }
end
local dbTable = {}
local starting = 210000
local ending = 219999

for id = starting, ending do
	if GetWeaponData(id) then
		dbTable[id] = GetWeaponData(id)
		dbTable[id].name = string.lower(TEXT(("Sys%d_name"):format(id)))
	end
end

return dbTable
