local DebtRemainInfo = {}
_G.DebtRemainInfo = DebtRemainInfo

local DebtRemainInfoFrame = CreateUIComponent("Frame", "", "UIParent")
DebtRemainInfo.Frame = DebtRemainInfoFrame

DebtRemainInfoFrame:SetScripts("OnLoad", [=[ DebtRemainInfo_OnLoad(this); ]=])
DebtRemainInfoFrame:SetScripts("OnEvent", [=[ DebtRemainInfo_OnEvent(this, event); ]=])

function DebtRemainInfo_OnLoad(this)
	this:RegisterEvent("CASTING_START")
	this:RegisterEvent("CHAT_MSG_SYSTEM")
end

function DebtRemainInfo_OnEvent(this, event)
	if event == "CASTING_START" and arg1 == TEXT("GUILD_LIBRARY01") then
		this.time = arg2
		this.value = GetPlayerExpDebt()
	elseif event == "CHAT_MSG_SYSTEM" then
		if string.find(arg1, TEXT("GUILD_LIBRARY04")) then
			this.value = GetPlayerExpDebt() - this.value
			local outstr, hh, mm --, ss
			local lefttime = GetPlayerExpDebt() * this.time * (-1) / this.value
			
			hh = math.floor(lefttime / 3600)
			lefttime = lefttime - (hh * 3600)
			mm = math.floor(lefttime / 60)
			-- lefttime = lefttime - (mm * 60)
			-- ss = math.floor(lefttime)
			
			outstr = tostring(hh)..UNIT_HOUR..string.format("%02d", mm)..UNIT_MINUTE --..string.format("%02d", ss)..UNIT_SECOND
			arg1 = arg1.."|cffFFFF66"..string.format(". "..MERCHANT_ITEM_TIMER, outstr)
		elseif string.find(arg1, TEXT("GUILD_LIBRARY03")) then
			this.time = nil
			this.value = nil
		end
	end
end