MainMenuFrame:Hide()
--[[SUI = {}
SUI.Icon = "interface\\Icons\\quest_hammer04";
_G.SUI = SUI;]]--
local colorbyclass = {    
	[TEXT("SYS_CLASSNAME_WARRIOR")]	= { r = 0.984 , g = 0.255 , b = 0.024 },    
	[TEXT("SYS_CLASSNAME_RANGER")]	= { r = 0.647 , g = 0.839 , b = 0.011 },
	[TEXT("SYS_CLASSNAME_THIEF")]	= { r = 0.000 , g = 0.839 , b = 0.773 },  
	[TEXT("SYS_CLASSNAME_MAGE")]	= { r = 0.988 , g = 0.447 , b = 0.067 },   
	[TEXT("SYS_CLASSNAME_AUGUR")]	= { r = 0.157 , g = 0.549 , b = 0.925 },       	         
	[TEXT("SYS_CLASSNAME_KNIGHT")]	= { r = 0.878 , g = 0.886 , b = 0.294 },        
	[TEXT("SYS_CLASSNAME_WARDEN")]	= { r = 0.757 , g = 0.290 , b = 0.819 },             
	[TEXT("SYS_CLASSNAME_DRUID")]	= { r = 0.380 , g = 0.819 , b = 0.378 },  
	[TEXT("SYS_CLASSNAME_HARPSYN")]	= { r = 0.380 , g = 0.169 , b = 0.914 },
	[TEXT("SYS_CLASSNAME_PSYRON")]	= { r = 0.188 , g = 0.149 , b = 0.949 },
	[TEXT("SYS_CLASSNAME_BARD")]	= { r = 0.000 , g = 0.521 , b = 0.349 },
}

local playerattribute = {
	{value = "STR", name = C_STR},
	{value = "AGI", name = C_AGI},
	{value = "STA", name = C_STA},
	{value = "INT", name = C_INT},
	{value = "MND", name = C_MND},
	
	{value = "DPS", name = C_DPS},
	
	{value = "MELEE_MAIN_DAMAGE", name = TEXT("SC_SKILLTIPS_POWER")},
	{value = "MELEE_ATTACK", name = C_PHYSICAL_ATTACK},
	{value = "MELEE_CRITICAL", name = TEXT("SC_SKILLTIPS_CRI_POWER")},
	{value = "PHYSICAL_MAIN_HIT", name = TEXT("SC_SKILLTIPS_HIT")},
	
	{value = "RANGE_DAMAGE", name = TEXT("SC_SKILLTIPS_RANGEPW")},
	{value = "RANGE_ATTACK", name = C_PHYSICAL_ATTACK},
	{value = "RANGE_CRITICAL", name = TEXT("SC_SKILLTIPS_CRI_POWER")},
	{value = "PHYSICAL_MAIN_HIT", name = TEXT("SC_SKILLTIPS_HIT")},

	{value = "MAGIC_DAMAGE", name = TEXT("SC_SKILLTIPS_MDMG")},
	{value = "MAGIC_ATTACK", name = C_MAGIC_ATTACK},
	{value = "MAGIC_CRITICAL", name = TEXT("SC_SKILLTIPS_MCRI_POWER")},
	{value = "MAGIC_HIT", name = TEXT("SC_SKILLTIPS_MAG_HIT")},
	{value = "MAGIC_HEAL", name = TEXT("SC_SKILLTIPS_HEAL")},

	{value = "PHYSICAL_DEFENCE", name = TEXT("SC_SKILLTIPS_DEF")},
	{value = "PHYSICAL_PARRY", name = TEXT("SC_SKILLTIPS_PARRY")},
	{value = "PHYSICAL_DODGE", name = TEXT("SC_SKILLTIPS_DOGE")},
	{value = "PHYSICAL_RESIST_CRITICAL", name = C_PHYSICAL_RESIST_CRITICAL},

	{value = "MAGIC_DEFENCE", name = TEXT("SC_SKILLTIPS_MDEF")},
	{value = "MAGIC_DODGE", name = TEXT("SC_SKILLTIPS_MDOGE")},
	{value = "MAGIC_RESIST_CRITICAL", name = C_MAGIC_RESIST_CRITICAL},
}

function SUI_ExperienceFrame_OnLoad(this)
	this:RegisterEvent("VARIABLES_LOADED")
	this:RegisterEvent("PLAYER_EXP_CHANGED")
	this:RegisterEvent("TP_EXP_UPDATE")
end

function SUI_ExperienceFrame_OnEvent(this, event)
	if event == "VARIABLES_LOADED" then
		ExperienceFrame:UnregisterEvent("PLAYER_EXP_CHANGED")
		ExperienceFrame:Hide()
		SUI_ExperienceStatusBar_Update()
	elseif event == "PLAYER_EXP_CHANGED" then
		SUI_ExperienceStatusBar_Update()
	elseif event == "TP_EXP_UPDATE" then
		SUI_TPText:SetText(MoneyNormalization(GetTpExp()).." "..SKILLBOOK_TP)
	end
end

function SUI_ExperienceStatusBar_Update()
	local mexp = GetPlayerMaxExp()
	local cexp = GetPlayerExp()
	local ctp = GetTpExp()
	local dexp, dtp = GetPlayerExpDebt()
	
	SUI_ExperienceStatusBar:SetMaxValue(mexp)
	SUI_ExperienceStatusBar:SetValue(cexp)
	SUI_ExperienceText:SetText(MoneyNormalization(cexp).."/"..MoneyNormalization(mexp)..string.format(" (%.0f%s", cexp / mexp * 100, "%)"))
	SUI_TPText:SetText(MoneyNormalization(ctp).." "..SKILLBOOK_TP)
	SUI_EnchExpText:SetText("+"..MoneyNormalization(mexp - cexp))

	local exp, tp = GetPlayerExtraPoint()
	if exp > 0 then
		local value = exp + cexp
		if value > mexp then
			value = mexp
		end
		SUI_ExtraExperienceFrame:ClearAllAnchors()
		SUI_ExtraExperienceFrame:SetAnchor("TOP", "TOPLEFT", "SUI_ExperienceStatusBar", SUI_ExperienceStatusBar:GetWidth() * value / mexp, -2)
		SUI_ExtraExperienceFrame:Show()
	else
		SUI_ExtraExperienceFrame:Hide()
	end

	if tp > 0 then
		local value = tp * 10 + cexp
		if value > mexp then
			value = mexp
		end
		SUI_ExtraSkillPointFrame:ClearAllAnchors()
		SUI_ExtraSkillPointFrame:SetAnchor("BOTTOM", "BOTTOMLEFT", "SUI_ExperienceStatusBar", SUI_ExperienceStatusBar:GetWidth() * value / mexp, 2)
		SUI_ExtraSkillPointFrame:Show()
	else
		SUI_ExtraSkillPointFrame:Hide()
	end
	
	if dexp ~= 0 or dtp ~= 0 then
		local value = dexp * -1
		if value > mexp then
			value = mexp
		end
		SUI_ExperienceDebtFrame:ClearAllAnchors()
		SUI_ExperienceDebtFrame:SetAnchor("CENTER", "LEFT", "SUI_ExperienceStatusBar", SUI_ExperienceStatusBar:GetWidth() * value / mexp, 0)
		SUI_ExperienceDebtFrame:Show()
	else
		SUI_ExperienceDebtFrame:Hide()
	end
end

function SUI_ExperienceStatusBar_OnEnter(this)
	local mexp = GetPlayerMaxExp()
	local cexp = GetPlayerExp()
	GameTooltip:SetOwner(this, "ANCHOR_TOP", 0, 0)
	GameTooltip:SetText(CLASSLIST_TOOLTIP, 1, 0,13, 0,85)
	GameTooltip:AddSeparator()
	for i = 1, GetPlayerNumClasses() do
		local class, token, level, curvalue, maxvalue = GetPlayerClassInfo(i, true)
		local color = g_ClassColors[token]
		GameTooltip:AddDoubleLine(class.." ["..level.."]", MoneyNormalization(curvalue).."/"..MoneyNormalization(maxvalue), color.r, color.g, color.b, color.r, color.g, color.b)
	end
	GameTooltip:AddSeparator()
	GameTooltip:AddDoubleLine(TEXT("SYS_SKILL_POINT"), MoneyNormalization(GetTpExp()), 1, 0.82, 0, 1, 0.82, 0)
	GameTooltip:AddDoubleLine(C_LEVELUP, MoneyNormalization(mexp - cexp), 1, 0.82, 0, 1, 0.82, 0)
	
	local exp, tp = GetPlayerExtraPoint()
	if exp > 0 or tp > 0 then
		GameTooltip:AddSeparator()
		GameTooltip:AddLine(EXTRA_POINT_TIP, 1, 1, 1)
		if exp > 0 then
			GameTooltip:AddDoubleLine(QUESTBOOK_QUESTREWARD_EXP, MoneyNormalization(exp), 0, 0.82, 1, 0, 0.82, 1)
		end
		if tp > 0 then
			GameTooltip:AddDoubleLine(QUESTBOOK_QUESTREWARD_TP, MoneyNormalization(tp), 0, 0.82, 1, 0, 0.82, 1)
		end
	end
	
	local mainExp, mainTp, subExp, subTp = GetPlayerExpDebt()
	if mainExp ~= 0 or mainTp ~= 0 or (subExp and subExp ~= 0) or (subTp and subTp ~= 0) then
		GameTooltip:AddSeparator()
		GameTooltip:AddLine(DEBT_EXPERIENCE_TIPS_TITLE, 1, 0,13, 0,85)
		local text = mainExp
		if subExp then
			text = text.." ("..subExp..")"
		end
		GameTooltip:AddDoubleLine(DEBT_EXP, text, 1, 0.42, 0, 1, 0.42, 0)
		text = mainTp
		if subTp then
			text = text.." ("..subTp..")"
		end
		GameTooltip:AddDoubleLine(DEBT_TP, text, 1, 0.42, 0, 1, 0.42, 0)
	end
end

function SUI_PlayerExtraTips_Show(this, type)
	local exp, tp = GetPlayerExtraPoint()
	local _,_,_,x1 = SUI_ExtraExperienceFrame:GetAnchor()
	local _,_,_,x2 = SUI_ExtraSkillPointFrame:GetAnchor()
	if math.abs(x1 - x2) < 10 then
		all = 1
	end

	GameTooltip:SetOwner(this, "ANCHOR_TOP")
	GameTooltip:SetText(TEXT("EXTRA_POINT_TIP"), 1, 0,13, 0,85)
	GameTooltip:AddSeparator()
	if all or type == "EXP" then
		GameTooltip:AddDoubleLine(TEXT("FURNITURE_EXPPOINT"), "+"..MoneyNormalization(exp), 0, 0.6, 1, 0, 0.6, 1)
	end
	if all or type == "TP" then
		GameTooltip:AddDoubleLine(TEXT("FURNITURE_TPPOINT"), "+"..MoneyNormalization(tp), 1, 0.8, 0, 1, 0.8, 0)
	end	
end

------------------------------------------------------------------------

function SUI_BackPackButton_OnLoad(this)
	this:RegisterForClicks("LeftButton", "RightButton")
	this:RegisterEvent("PLAYER_MONEY")
	this:RegisterEvent("PLAYER_TRADE_MONEY")
	
	SUI_BackPackButtonIcon:SetTexture("interface/moneyframe/moneyicons")
	SUI_BackPackButtonIcon:SetTexCoord(0, 0.03125, 0, 1)
	SUI_BackPackButton_OnEvent(this, event)
end

function SUI_BackPackButton_OnEvent(this, event)
	local money = GetPlayerMoney("copper")
	if money >= 1000000 then
		SUI_BackPackButtonText:SetText(string.format( " %0.1f" , money / 1000000).."m")
	elseif money >= 1000 then
		SUI_BackPackButtonText:SetText(string.format( " %0.1f" , money / 1000).."k")
	else
		SUI_BackPackButtonText:SetText(money)
	end
end

function SUI_BackPackButton_OnClick(this, key)
	if key == "LBUTTON" then
		ToggleBackpack()
	elseif key == "RBUTTON" then
		PlaySoundByPath("sound\\interface\\ui_generic_click.mp3")
		OpenBank()
		--ToggleUIFrame(BankFrame)
	end
end

function SUI_BackPackButton_OnEnter(this)
	GameTooltip:SetOwner(this, "ANCHOR_TOPLEFT", 52, 0)
	GameTooltip:SetText(BACKPACK, 1, 0,13, 0,85)
	GameTooltip:AddLine(BANK, 0.0, 0.75, 0.95)
	GameTooltip:AddSeparator()
	local curCount, maxCount = GetBagCount()
	if curCount == maxCount then
		GameTooltip:AddDoubleLine(BACKPACK, curCount.."/"..maxCount, 1, 1, 1, 1, 0, 0)
	elseif (curCount / maxCount) > 0.9 then
		GameTooltip:AddDoubleLine(BACKPACK, curCount.."/"..maxCount, 1, 1, 1, 1, 0.5, 0)
	else
		GameTooltip:AddDoubleLine(BACKPACK, curCount.."/"..maxCount, 1, 1, 1, 1, 0.82, 0)
	end
	local count = 0
	for i = 51, 60 do
		local icon, name, curcount, locked = GetGoodsItemInfo(i)
		if name ~= "" then
			count = count + 1
		end
	end
	GameTooltip:AddDoubleLine(MAGICBOX_TITLE, count.."/5", 1, 1, 1, 1, 0.82, 0)
	local count = 0
	for i = 1, 50 do
		local icon, name, curcount, locked = GetGoodsItemInfo(i)
		if name ~= "" then
			count = count + 1
		end
	end
	GameTooltip:AddDoubleLine(GOODSPACK, count.."/50", 1, 1, 1, 1, 0.82, 0)
	
	local count = 0
	local maxcount = 40
	for i = 2, 5 do
		local PageLetTime = TimeLet_GetLetTime( "BankBag"..i)
		if PageLetTime and PageLetTime >= 0 then
			maxcount = maxcount + 40
		end
	end
	local count = 0
	for i = 1, GetBankNumItems() do
		local icon, name, curcount, locked = GetBankItemInfo(i)
		if name then
			count = count + 1
		end
	end
	GameTooltip:AddDoubleLine(BANK, count.."/"..maxcount, 1, 1, 1, 1, 0.82, 0)
	
	GameTooltip:AddSeparator()
	GameTooltip:AddDoubleLine(MONEY_GOLD, MoneyNormalization(GetPlayerMoney("copper")), 1, 1, 1, 1, 0.82, 0)
	GameTooltip:AddDoubleLine(MONEY_RUNE, MoneyNormalization(GetPlayerMoney("account")), 1, 1, 1, 1, 0.82, 0)
	GameTooltip:AddDoubleLine(MONEY_RUBY, MoneyNormalization(GetPlayerMoney("bonus")), 1, 1, 1, 1, 0.82, 0)
	
	local asd = 0
	local bitem = {203038, 206879, 240181, 208681, 206686}
	for j = 1, 5 do
		local bagttl = 0
		local bankttl = 0
		local total = 0
		local itemname = TEXT("Sys"..bitem[j].."_name")
		local itemnames = TEXT("Sys"..bitem[j].."_name_plural")
		local r, g, b = GetItemQualityColor(GetQualityByGUID(bitem[j]))
		for i = 1, 60 do
			local icon, name, count, locked = GetGoodsItemInfo(i)
			if name == itemname then
				bagttl = bagttl + count
			end
		end
		local _, max = GetBagCount()
		for i = 1, max do
			local index, texture, name, count, locked, quality = GetBagItemInfo(i)
			if name == itemname then
				bagttl = bagttl + count
			end
		end
		for i = 1, GetBankNumItems() do
			local icon, name, count, locked = GetBankItemInfo(i)
			if name == itemname then
				bankttl = bankttl + count
			end
		end
		if bagttl + bankttl > 0 and asd == 0  then
			GameTooltip:AddSeparator()
			asd = 1
		end
		if bagttl + bankttl > 0 then
			GameTooltip:AddDoubleLine(itemnames, bagttl + bankttl.." (|cff3399FF"..bagttl.."|r+|cffFF9933"..bankttl.."|r)", r, g, b, 1, 0.82, 0)
		end
	end
end


function SUI_CharacterButton_OnLoad(this)
	this:RegisterForClicks("LeftButton", "RightButton")
	this:RegisterEvent("PLAYER_INVENTORY_CHANGED")
	
	SUI_CharacterButtonIcon:SetTexture("Interface/gameicon/gameicon")
	SUI_CharacterButtonIcon:SetTexCoord(0.25, 0.375, 0.375, 0.5)
	SUI_CharacterButton_OnEvent(this, event)
end

function SUI_CharacterButton_OnEvent(this, event)
	local totalvalue = 0
	local totalmax = 0
	local count = 0
	for i = 0, 16 do
		local durableValue, durableMax = GetInventoryItemDurable("player", i)
		if durableMax and durableMax > 0 and i ~= 9 then
			totalvalue = totalvalue + durableValue
			totalmax = totalmax + durableMax
			count = count + 1
		end
	end
	local parvalue = math.floor(totalvalue / count)
	local parmax = math.floor(totalmax / count)
	if parmax > 0 then
		SUI_CharacterButtonText:SetText(string.format("%.0f%s", parvalue / parmax * 100, "%"))
		SUI_CharacterButtonText:SetColor(1, 1, 1)
	else
		SUI_CharacterButtonText:SetText(NONE.." ("..GetEuipmentNumber()..")")
		SUI_CharacterButtonText:SetColor(0.5, 0.5, 0.5)
	end
end

function SUI_CharacterButton_OnClick(this, key)
	--local BagSlotCount,BagSize,MaxBagSlots = GetBagCount()
	--Hammer = "interface\Icons\quest_hammer04"
	if IsShiftKeyDown() and key == "LBUTTON" then
		GameTooltip:Hide()
		SUI_CharacterButton_OnEnter(this, GameTooltipHyperLink)
	elseif key == "LBUTTON" then
		ToggleCharacter("EquipmentFrame")
	elseif key == "RBUTTON" then
		--SUI.SearchForItem()
		--i,BagSize = string.find(s,"quest_hammer04")
		ToggleUIFrame(SkillSuitFrame)
	end
end

--[[function SUI.SearchForItem()
	local BagSlotCount,BagSize,MaxBagSlots = GetBagCount()
	print("hi")
	for i = 1,BagSize do
		local inventoryIndex, texture, name, itemCount, locked, invalid = GetBagItemInfo(i)
		local index = GetBagItemInfo(inventoryIndex)
		if (index==SUI.Icon) then
			print("useitme")
			UseBagItem(inventoryIndex)
			return
		end
    end
	for bagIndex = 1,BagSize do
	local inventoryIndex, icon, name, itemCount, locked, invalid = GetBagItemInfo(bagIndex)
	local link = GetBagItemLink(inventoryIndex)
end]]--
	

function SUI_CharacterButton_OnEnter(this, tooltip)

	--if (SUI.Icon ~= "")then
		--SUI.SearchForItem()
	--end
	
	if tooltip ~= GameTooltipHyperLink then
		tooltip:SetOwner(this, "ANCHOR_TOPLEFT", 52, 0)
	end
	tooltip:SetText(SYSTEM_CHARACTER, 1, 0,13, 0,85)
	tooltip:AddLine(TEXT("SUITSKILL_FRAME"), 0.0, 0.75, 0.95)
	tooltip:AddSeparator()
	
	local totalvalue = 0
	local totalmax = 0
	local count = 0
	for i = 0, 16 do
		if i ~= 9 then
			local durableValue, durableMax, name = GetInventoryItemDurable("player", i)
			if durableMax and durableMax > 0 and i ~= 9 then
				local r, g, b = GetItemQualityColor(GetInventoryItemQuality("player", i))
				local r2, g2, b2 = GetDuraColor(durableValue, durableMax)
				tooltip:AddDoubleLine(name, durableValue.."/"..durableMax, r, g, b, r2, g2, b2)
				totalvalue = totalvalue + durableValue
				totalmax = totalmax + durableMax
				count = count + 1
			end
		end
	end
	local parvalue = math.floor(totalvalue / count)
	local parmax = math.floor(totalmax / count)
	if parmax > 0 then
		local r, g, b = GetDuraColor(parvalue, parmax)
		tooltip:AddSeparator()
		tooltip:AddDoubleLine(TEXT("SYS_ITEM_DURABLE").." ("..string.format("%.0f%s", parvalue / parmax * 100, "%)"), parvalue.."/"..parmax, r, g, b, r, g, b)
	end
	
	if GetInventoryItemCount("player", 9) then
		local ammo = GetInventoryItemCount("player", 9)
		local durableValue, durableMax, name = GetInventoryItemDurable("player", 9)
		local r, g, b = GetItemQualityColor(GetInventoryItemQuality("player", 9))
		if ammo >= 50 then
			tooltip:AddDoubleLine(name, ammo, r, g, b, 1, 1, 1)
		else
			tooltip:AddDoubleLine(name, ammo, r, g, b, 1, 0, 0)
		end
	end
end


function SUI_CraftButton_OnLoad(this)
	this:RegisterForClicks("LeftButton", "RightButton")
	this:RegisterEvent("PLAYER_BAG_CHANGED")
	
	SUI_CraftButtonIcon:SetTexture("Interface/gameicon/gameicon")
	SUI_CraftButtonIcon:SetTexCoord(0.75, 0.875, 0, 0.125)
	SUI_CraftButton_OnEvent(this, event)
end

function SUI_CraftButton_OnEvent(this, event)
	local curCount, maxCount = GetBagCount()
	SUI_CraftButtonText:SetText(curCount.."/"..maxCount)
end

function SUI_CraftButton_OnClick(this, key)
	if key == "LBUTTON" and IsShiftKeyDown() then
		GameTooltip:Hide()
		SUI_CraftButton_OnEnter(this, GameTooltipHyperLink)
	elseif key == "LBUTTON" then
		ToggleUIFrame(CraftFrame)
	elseif key == "RBUTTON" then
		ToggleUIFrame(AchievementTitleFrame)
	end
end

function SUI_CraftButton_OnEnter(this, tooltip)
	if tooltip ~= GameTooltipHyperLink then
		tooltip:SetOwner(this, "ANCHOR_TOPLEFT", 52, 0)
	end
	tooltip:SetText(SYSTEM_CRAFT, 1, 0,13, 0,85)
	GameTooltip:AddLine(SYSTEM_TITLE, 0.0, 0.75, 0.95)
	tooltip:AddSeparator()
	
	for i = 1, 3 do
		local group = Crafting_Group_Gather.Items[i]
		local CurValue = GetPlayerCurrentSkillValue(group.ID)
		if CurValue > 0 then
			local lv =  math.floor(CurValue)
			local totalExp = (CurValue - lv) * 100

			if totalExp > 99.99 then
				totalExp = 99.99
			end

			local value = string.format("%.2f", totalExp)
			local r, g, b = GetRankColor(group.ID)
			tooltip:AddDoubleLine(group.Name, C_LV_WORD.." "..lv.." ("..value.."%)", r, g, b, 1, 0.82, 0)
		end
	end
	for i = 1, 6 do
		local group = Crafting_Group_Craft.Items[i]
		local CurValue = GetPlayerCurrentSkillValue(group.ID)
		if CurValue > 0 then
			local lv =  math.floor(CurValue)
			local totalExp = (CurValue - lv) * 100

			if totalExp > 99.99 then
				totalExp = 99.99
			end

			local value = string.format("%.2f", totalExp)
			local r, g, b = GetRankColor(group.ID)
			tooltip:AddDoubleLine(group.Name, C_LV_WORD.." "..lv.." ("..value.."%)", r, g, b, 1, 0.82, 0)
		end
	end

	local group = Crafting_Group_Other.Items[1]
	local CurValue = GetPlayerCurrentSkillValue(group.ID)
	if CurValue > 0 then
		local lv =  math.floor(CurValue)
		local totalExp = (CurValue - lv) * 100

		if totalExp > 99.99 then
			totalExp = 99.99
		end

		local value = string.format("%.2f", totalExp)
		local r, g, b = GetRankColor(group.ID)
		tooltip:AddDoubleLine(group.Name, C_LV_WORD.." "..lv.." ("..value.."%)", r, g, b, 1, 0.82, 0)
	end
end


function SUI_SkillBookButton_OnLoad(this)
	this:RegisterForClicks("LeftButton", "RightButton")
end

function SUI_SkillBookButton_OnEvent(this, event)
end

function SUI_SkillBookButton_OnClick(this, key)
	if key == "LBUTTON" and IsShiftKeyDown() then
		GameTooltip:Hide()
		SUI_SkillBookButton_OnEnter(this, GameTooltipHyperLink)
	elseif key == "LBUTTON" then
		ToggleUIFrame(UI_SkillBook)
	end
end

function SUI_SkillBookButton_OnEnter(this, tooltip)
	if tooltip ~= GameTooltipHyperLink then
		tooltip:SetOwner(this, "ANCHOR_TOPLEFT", 104, 0)
	end
	tooltip:SetText(SYSTEM_SKILL, 1, 0,13, 0,85)
	tooltip:AddSeparator()
	for i = 1, 26 do
		local label = playerattribute[i].name
		local baseValue, otherValue, persentage = GetPlayerAbility(playerattribute[i].value)
		local value = baseValue + otherValue
		if otherValue > 0 then
			value = GREEN_FONT_COLOR_CODE..value..FONT_COLOR_CODE_CLOSE.." ("..baseValue..GREEN_FONT_COLOR_CODE.."+"..otherValue.."|r)"
		elseif otherValue < 0 then
			value = RED_FONT_COLOR_CODE..value..FONT_COLOR_CODE_CLOSE.." ("..baseValue..RED_FONT_COLOR_CODE.."-"..otherValue.."|r)"
		end
		if persentage then
			value = value.." ["..NORMAL_FONT_COLOR_CODE..string.format("%.2f", persentage).."%|r]"
		end
		if i <= 5 then
			tooltip:AddDoubleLine(label, value, 1, 0.5, 0, 1, 1, 1)
		elseif i <= 6 then
			tooltip:AddDoubleLine(label, string.format("%.2f", baseValue + otherValue), 0, 1, 1, 1, 1, 1)
		elseif i <= 10 then
			tooltip:AddDoubleLine(label, value, 1, 1, 0, 1, 1, 1)
		elseif i <= 14 then
			tooltip:AddDoubleLine(label, value, 1, 0.75, 0, 1, 1, 1)
		elseif i <= 19 then
			tooltip:AddDoubleLine(label, value, 1, 0.25, 0, 1, 1, 1)
		elseif i <= 23 then
			tooltip:AddDoubleLine(label, value, 0, 0.5, 1, 1, 1, 1)
		else
			tooltip:AddDoubleLine(label, value, 0, 1, 0.5, 1, 1, 1)
		end
	end
end


function SUI_QuestBookButton_OnLoad(this)
	this:RegisterForClicks("LeftButton", "RightButton")
	this:RegisterEvent("RESET_QUESTBOOK")
	SUI_QuestBookButtonText:SetColor(0, 1, 0.4)
	SUI_QuestBookButtonIcon:SetTexture("Interface/gameicon/gameicon")
	SUI_QuestBookButtonIcon:SetTexCoord(0, 0.125, 0.125, 0.25)
	SUI_QuestBookButton_OnEvent(this, event)
end

function SUI_QuestBookButton_OnEvent(this, event)
	local daily, dailyMax = Daily_count()
	SUI_QuestBookButtonText:SetText(daily.."/"..dailyMax)
end

function SUI_QuestBookButton_OnClick(this, key)
	if key == "LBUTTON" then
		ToggleUIFrame(UI_QuestBook)
	elseif key == "RBUTTON" then
		ToggleUIFrame(NewCardFrame)
	end
end

function SUI_QuestBookButton_OnEnter(this)
	GameTooltip:SetOwner(this, "ANCHOR_TOPLEFT", 52, 0)
	GameTooltip:SetText(SYSTEM_QUEST, 1, 0,13, 0,85)
	--GameTooltip:AddLine(SYSTEM_CARDBOOK, 0, 0.75, 0.95)
	
	
--	GameTooltip:AddSeparator()
--	for i = 0, 15 do 
--		if LuaFunc_GetCardMaxCount(i) > 0 then 
--			local race = LuaFunc_GetString("SYS_RACE_"..i)
--			local count = string.format("%d/%d", LuaFunc_GetCardCount(i), LuaFunc_GetCardMaxCount(i))
--			DEFAULT_CHAT_FRAME:AddMessage("ZyDebug: #"..i..": "..race.." "..count.." ");
--			if LuaFunc_GetCardCount(i) == LuaFunc_GetCardMaxCount(i) then
--				GameTooltip:AddDoubleLine(race, count, 0, 0.8, 0, 0, 0.8, 0)
--			else
--				GameTooltip:AddDoubleLine(race, count, 1, 1, 1, 1, 0.8, 0)
--			end
--		end
--	end
--	
	GameTooltip:AddSeparator()
	local totalQuest = GetNumQuestBookButton_QuestBook()
	local completeQuest = 0
	if totalQuest > 0 then
		for i = 1, totalQuest do
			local index, ID, questName, track, questLV, daily, _, _, _, complete = GetQuestInfo(i)
			if complete then
				completeQuest = completeQuest + 1
			end
		end
	end
	GameTooltip:AddDoubleLine(SPEAK_QUESTCATALOG_3, completeQuest.."/"..totalQuest, 1, 1, 1, 1, 226 / 255, 0)
end


function SUI_SystemButton_OnLoad(this)
	this:RegisterForClicks("LeftButton", "RightButton")
	SUI_SystemButtonIcon:SetTexture("Interface/mainmenuframe/mainmenu-systembutton-normal")
	SUI_SystemButtonIcon:SetTexCoord(0.234375, 0.75, 0.203125, 0.71875)
	SUI_SystemButtonIcon:ClearAllAnchors()
	SUI_SystemButtonIcon:SetAnchor("RIGHT", "RIGHT", SUI_SystemButton, 0, 0)
end

function SUI_SystemButton_OnEvent(this, event)
end

function SUI_SystemButton_OnClick(this, key)
	if key == "LBUTTON" then
		ToggleMainPopupMenu()
	elseif key == "RBUTTON" then
		ToggleTimeFlagPopupMenu()
	end
end

function SUI_SystemButton_OnEnter(this)
	GameTooltip:SetOwner(this, "ANCHOR_TOPLEFT", 16, 0)
	GameTooltip:SetText(SYSTEM_TOOLTIP, 1, 0,13, 0,85)
	GameTooltip:AddLine(TIMEFLAG_TITLE, 0.0, 0.75, 0.95)
end


function SUI_TransportButton_OnLoad(this)
	this:RegisterForClicks("LeftButton", "RightButton")
	SUI_TransportButtonIcon:SetTexture("Interface/transportbook/tb_button-normal")
	SUI_TransportButtonIcon:SetTexCoord(0.234375, 0.75, 0.203125, 0.71875)
	SUI_TransportButtonIcon:ClearAllAnchors()
	SUI_TransportButtonIcon:SetAnchor("RIGHT", "RIGHT", SUI_TransportButton, 0, 0)
end

function SUI_TransportButton_OnEvent(this, event)
end

function SUI_TransportButton_OnClick(this, key)
	if key == "LBUTTON" then
		OnClick_TeleportButton(this)
	end
end

function SUI_TransportButton_OnEnter(this)
	GameTooltip:SetOwner(this, "ANCHOR_TOPLEFT", 16, 0)
	GameTooltip:SetText(TB_TITLE , 1, 0,13, 0,85)
	GameTooltip:AddSeparator()
	
	local tpitem = {202902, 202903, 202904, 202905, 202435, 203784}
	for i = 1, 6 do
		local total = 0
		local itemname = TEXT("Sys"..tpitem[i].."_name")
		local r, g, b = GetItemQualityColor(GetQualityByGUID(tpitem[i]))
		for j = 1, 60 do
			local icon, name, count, locked = GetGoodsItemInfo(j)
			if name == itemname then
				total = total + count
			end
		end
		local _, max = GetBagCount()
		for h = 1, max do
			local index, texture, name, count, locked, quality = GetBagItemInfo(h)
			if name == itemname then
				total = total + count
			end
		end
		GameTooltip:AddDoubleLine(itemname, total, r, g, b, 1, 0.82, 0)
	end
end


function SUI_GuildButton_OnLoad(this)
	this:RegisterForClicks("LeftButton", "RightButton")
	this:RegisterEvent("UPDATE_GUILD_MEMBER")
	
	SUI_GuildButtonIcon:SetTexture("Interface/gameicon/gameicon")
	SUI_GuildButtonIcon:SetTexCoord(0.25, 0.375, 0.125, 0.25)
	SUI_GuildButton_OnEvent(this, event)
end

function SUI_GuildButton_OnEvent(this, event)
	local guildTotal = GetNumGuildMembers()
	local guildOnline = 0
	for i = 1, guildTotal do
		local name, rank, class, level, subClass, subLevel, _, _, _, _,isOnline = GetGuildRosterInfo(i)
		if isOnline then
			guildOnline = guildOnline + 1
		end
	end
	SUI_GuildButtonText:SetText(guildOnline.."/"..guildTotal)
end

function SUI_GuildButton_OnClick(this, key)
	if key == "LBUTTON" then
		ToggleUIFrame(GuildFrame)
	elseif key == "RBUTTON" then
		GameTooltip:Hide()
		ToggleDropDownMenu(SUI_GuildDropDownMenu, 1, nil, this, 0, 0)
	end
end

function SUI_GuildButton_OnEnter(this)
	GameTooltip:SetOwner(this, "ANCHOR_TOPLEFT", 52, 0)
	GameTooltip:SetText(SOCIAL_GUILD, 1, 0,13, 0,85)
	GameTooltip:AddLine(PARTY_INVITE, 0.0, 0.75, 0.95)
	
	local h = 1
	if GetNumGuildMembers() == 0 then
		GameTooltip:AddSeparator()
		GameTooltip:AddLine(GF_STR_NOGUILD_MSG, 0.75, 0.75, 0.75)
	else
		for i = 1, GetNumGuildMembers() do
			local name, rank, class, level, subClass, subLevel, _, _, _, _,isOnline, _, zone = GetGuildRosterInfo(i)
			local color = {}
			if colorbyclass[class] then
				color = colorbyclass[class]
			else
				color = {r = 1 , g = 1 , b = 1}
			end
			if h and isOnline then
				GameTooltip:AddSeparator()
				h = nil
			end
			if isOnline then
				GameTooltip:AddDoubleLine(name.." ["..level.."/"..subLevel.."]", zone, color.r, color.g, color.b, 1, 1, 0)
			end
		end
	end
end


function SUI_FriendsButton_OnLoad(this)
	this:RegisterForClicks("LeftButton", "RightButton")
	this:RegisterEvent("ADD_FRIEND")	
	this:RegisterEvent("DEL_FRIEND")	
	this:RegisterEvent("RESET_FRIEND")
	this:RegisterEvent("ONLINE_FRIEND")
	
	SUI_FriendsButtonIcon:SetTexture("Interface/gameicon/gameicon")
	SUI_FriendsButtonIcon:SetTexCoord(0, 0.125, 0.375, 0.5)
	SUI_FriendsButton_OnEvent(this, event)
end

function SUI_FriendsButton_OnEvent(this, event)
	local friendTotal = GetFriendCount("Friend")
	local friendOnline = 0
	for i = 1, friendTotal do
		local name, _ ,online = GetFriendInfo("Friend", i)
		if online then
			friendOnline = friendOnline + 1
		end
	end
	SUI_FriendsButtonText:SetText(friendOnline.."/"..friendTotal)
end

function SUI_FriendsButton_OnClick(this, key)
	if key == "LBUTTON" then
		ToggleSocialFrame("Friend")
	elseif key == "RBUTTON" then
		GameTooltip:Hide()
		ToggleDropDownMenu(SUI_FriendsDropDownMenu, 1, nil, this, 0, 0)
	end
end

function SUI_FriendsButton_OnEnter(this)
	GameTooltip:SetOwner(this, "ANCHOR_TOPLEFT", 52, 0)
	GameTooltip:SetText(SOCIAL_FRIEND_LIST, 1, 0,13, 0,85)
	GameTooltip:AddLine(PARTY_INVITE, 0.0, 0.75, 0.95)
	local h = 1
	for i = 1, GetFriendCount("Friend") do
		local name, groupID ,online, each = GetFriendInfo("Friend", i)
		if h == 1 and online then
			GameTooltip:AddSeparator()
			h = 2
		end
		if online then
			if each then
				GameTooltip:AddLine(name, 1, 0.82, 0)
			else
				GameTooltip:AddLine(name, 1, 1, 1)
			end
		end
	end
	if h ~= 2 then
		GameTooltip:AddSeparator()
		GameTooltip:AddLine(GUILD_STR_OFFLINE, 0.75, 0.75, 0.75)
	end
end


function SUI_SwapEquipmentButton_OnLoad(this)
	this:RegisterForClicks("LeftButton", "RightButton")
	this:RegisterEvent("SWAP_EQUIPMENT_SUCCESS")
	
	SUI_SwapEquipmentButtonIcon:SetTexture("Interface/playerframe/playerframelevel-border")
	SUI_SwapEquipmentButtonIcon:SetTexCoord(0.1875, 0.8125, 0.1875, 0.8125)
	SUI_SwapEquipmentButtonIcon:ClearAllAnchors()
	SUI_SwapEquipmentButtonIcon:SetAnchor("RIGHT", "RIGHT", SUI_SwapEquipmentButton, 0, 0)
	SUI_SwapEquipmentButton_OnEvent(this, event)
end

function SUI_SwapEquipmentButton_OnEvent(this, event)
	SUI_SwapEquipmentButtonEquip:SetText(GetEuipmentNumber())
end

function SUI_SwapEquipmentButton_OnClick(this, key)
	if key == "LBUTTON" then
		SwapEquipmentItem(-1)
	elseif key == "RBUTTON" then
		GameTooltip:Hide()
		ToggleDropDownMenu(SUI_SwapEquipmentDropDownMenu, 1, nil, this, 0, 0)
	end
end

function SUI_SwapEquipmentButton_OnEnter(this)
	GameTooltip:SetOwner(this, "ANCHOR_TOPLEFT", 16, 0)
	GameTooltip:SetText(SWAP_EQUIPMENT_TOOLTIP, 1, 0,13, 0,85)
	GameTooltip:AddLine(FST_SELECT, 0.0, 0.75, 0.95)
end


function SUI_GuildList_Show()
	local info = {}
	info.text = SOCIAL_GUILD
	info.isTitle = 1
	info.notCheckable = 1
	UIDropDownMenu_AddButton(info)
	
	for i = 1, GetNumGuildMembers() do
		local name, rank, class, level, subClass, subLevel, _, _, _, _,isOnline, _, zone = GetGuildRosterInfo(i)
		if isOnline and name ~= UnitName("player") then
			info = {}
			info.notCheckable = 1
			info.text = name
			info.value = name
			info.func = function(this)
							if IsShiftKeyDown() then
								AskPlayerInfo(this.value)
							else
								InviteByName(this.value)
							end
						end
			info.tooltipText = PARTY_INVITE.."\n"..INQUIRE.." (Shift+Click)"
			UIDropDownMenu_AddButton(info)
		end
	end
end

function SUI_FriendsList_Show()
	local info = {}
	info.text = SOCIAL_FRIEND_LIST
	info.isTitle = 1
	info.notCheckable = 1
	UIDropDownMenu_AddButton(info)
	
	for i = 1, GetFriendCount("Friend") do 
		local name, _,isOnline, each = GetFriendInfo("Friend", i)
		if isOnline then
			info = {}
			info.notCheckable = 1
			info.text = name
			info.value = name
			info.func = function(this)
							if IsShiftKeyDown() then
								AskPlayerInfo(this.value)
							else
								InviteByName(this.value)
							end
						end
			info.tooltipText = PARTY_INVITE.."\n"..INQUIRE.." (Shift+Click)"
			UIDropDownMenu_AddButton(info)
		end
	end
end

function SUI_Timeflag_Show()
	local info = {}
	info.notCheckable = 1
	info.text = TIMEFLAG_TITLE
	info.func = function() TimeFlagFrame:Show() end
	UIDropDownMenu_AddButton(info)
	
	local info = {}
	info.notCheckable = 1
	info.text = TIMEFLAG_HANDY_MAIL
	info.func = function()
		if( TimeLet_GetLetTime( "MailLet" ) < 0 )then
			StaticPopup_Show("TIMEFLAG_FAIL1")
			return
		end
		OpenMail()
	end
	UIDropDownMenu_AddButton(info)
	
	local info = {}
	info.notCheckable = 1
	info.text = TIMEFLAG_HANDY_AUCTION
	info.func = function()
		if( TimeLet_GetLetTime( "AuctionLet" ) < 0 )then
			StaticPopup_Show("TIMEFLAG_FAIL1")
			return
		end
		OpenAuction()
	end
	UIDropDownMenu_AddButton(info)
	
	local info = {}
	info.notCheckable = 1
	info.text = BANK
	info.func = function()
		if( TimeLet_GetLetTime( "BankLet" ) < 0 )then
			-- StaticPopup_Show("TIMEFLAG_FAIL1")
			ToggleUIFrame(BankFrame)
			return
		end
		OpenBank()
	end
	UIDropDownMenu_AddButton(info)
end

function SUI_SwapEquipmentList_Show()
	local info = {}
	info.text = SWAP_EQUIPMENT_TOOLTIP
	info.isTitle = 1
	info.notCheckable = 1
	UIDropDownMenu_AddButton(info)
	
	for i = 1, 6 do
		info = {}
		info.notCheckable = 1
		info.text = i.." ".._glossary_00206
		info.func = function(this)
						SwapEquipmentItem(i - 1)
					end
		UIDropDownMenu_AddButton(info)
	end
end


function GetRankColor(id)
	local maxValue = GetPlayerMaxSkillValue(id)
	local r, g, b
	if maxValue >= 61 then
		r = 0.9609375
		g = 0.5546875
		b = 0.3359375
	elseif maxValue >= 41 then
		r = 0.78125
		g = 0.01953125
		b = 0.96875
	elseif maxValue >= 21 then
		r = 0
		g = 0.4453125
		b = 0.734375
	else
		r = 0
		g = 0.99609375
		b = 0
	end
	return r, g, b
end

function GetDuraColor(parvalue, parmax)
	local r, g, b
	local par = parvalue / parmax
	local total = math.floor(par * 100)
	if parvalue > 100 then
		r = 0
		g = 1
		b = 0
	elseif total >= 0 and total < 30 then
		par = par * 100 / 30
		r = 1
		g = par
		b = 0
	elseif total >= 30 and total < 50 then
		par = (par - 0.3) * 100 / 20
		r = 1
		g = 0.5 + par
		b = 0
	else
		r = 1
		g = par
		b = par
	end
	return r, g, b
end
