for i = 1, 10 do
	getglobal("ChatFrame"..i):SetBackdrop({
		edgeFile = "interface/addons/fslimui/textures/edge",
        bgFile = "interface/addons/fslimui/textures/backgroundd",        
        BackgroundInsets = {top = 0, left = 0, bottom = 0, right = 0},
        EdgeSize = 0,
        TileSize = 8,
    })
	
	getglobal("ChatFrame"..i.."Tab"):SetHeight(16)
	--getglobal("ChatFrame"..i.."Tab"):GetHighlightTexture():ClearAllAnchors()
	--getglobal("ChatFrame"..i.."Tab"):GetHighlightTexture():SetAnchor("LEFT", "LEFT", "ChatFrame"..i.."TabLeft", 0, 1)
	--getglobal("ChatFrame"..i.."Tab"):GetHighlightTexture():SetAnchor("RIGHT", "RIGHT", "ChatFrame"..i.."TabRight", 0, 1)
	getglobal("ChatFrame"..i.."TabText"):ClearAllAnchors()
	getglobal("ChatFrame"..i.."TabText"):SetAnchor("CENTER", "CENTER", "ChatFrame"..i.."Tab", 0, 1)
	getglobal("ChatFrame"..i.."TabLeft"):SetTexture("interface/addons/fslimui/textures/tab2") --tab
	getglobal("ChatFrame"..i.."TabLeft"):SetSize(8, 16)
	getglobal("ChatFrame"..i.."TabLeft"):SetColor(1, 1, 1)
	getglobal("ChatFrame"..i.."TabRight"):SetTexture("interface/addons/fslimui/textures/tab2")
	getglobal("ChatFrame"..i.."TabRight"):SetSize(8, 16)
	getglobal("ChatFrame"..i.."TabRight"):SetColor(1, 1, 1)
	getglobal("ChatFrame"..i.."TabMiddle"):SetTexture("interface/addons/fslimui/textures/tab2")
	getglobal("ChatFrame"..i.."TabMiddle"):SetSize(8, 16)
	getglobal("ChatFrame"..i.."TabMiddle"):SetColor(1, 1, 1)
	
	--getglobal("ChatFrame"..i.."ScrollBarUpButton"):GetNormalTexture():SetFile("interface/buttons/scrollbar-upbutton-normal")
	--getglobal("ChatFrame"..i.."ScrollBarDownButton"):GetNormalTexture():SetFile("interface/buttons/scrollbar-downbutton-normal")
	getglobal("ChatFrame"..i.."ScrollBarUpButton"):ClearAllAnchors()
	getglobal("ChatFrame"..i.."ScrollBarUpButton"):SetAnchor("TOPLEFT", "TOPLEFT", "ChatFrame"..i, 8, 8)
	getglobal("ChatFrame"..i.."ScrollBarDownButton"):ClearAllAnchors()
	getglobal("ChatFrame"..i.."ScrollBarDownButton"):SetAnchor("BOTTOMLEFT", "BOTTOMLEFT", "ChatFrame"..i, 8, -8)
end

function SUI_GuildChannelDropDownMenu_Show()
	for i = 1, GetNumGuildMembers() do
		local name, rank, class, level, subClass, subLevel, _, _, _, _,isOnline, _, zone = GetGuildRosterInfo(i)
		if isOnline and name ~= UnitName("player") then
			info = {}
			info.notCheckable = 1
			info.text = name
			info.value = name
			info.func = function(this)
							ChatFrame_SendTell(this.value)
						end
			UIDropDownMenu_AddButton(info)
		end
	end
end

function SUI_WisperChannelDropDownMenu_Show(this)
	local temp = nil
	info = {}
	info.text 	= CHANNEL_CHANGE_INPUT_WHISPER_TO
	info.value	= 1
	info.notCheckable = 1
	info.func = function(this) 
					StaticPopup_Show("WHISPER_TO")
				end
	UIDropDownMenu_AddButton(info, 1)
	
	for i = 1, GetFriendCount("Friend") do 
		local name, _,isOnline, each = GetFriendInfo("Friend", i)
		if isOnline then
			info = {}
			info.notCheckable = 1
			info.text = name
			info.value = name
			info.func = function(this)
							if IsShiftKeyDown() then
								InviteByName(this.value)
							else
								ChatFrame_SendTell(this.value)
							end
						end
			UIDropDownMenu_AddButton(info)
		end
	end
	
	for index, value in pairs(DEFAULT_CHAT_EDITBOX.tell) do
		if value and string.len(value) > 0 then
			info = {}
			info.text = value 
			info.value = value
			info.notCheckable = 1
			info.func = function(this) 
							ChatFrame_SendTell(this.value)
						end
			info.owner = DropDownframe
			UIDropDownMenu_AddButton(info, 1)
		end
	end

	local temp = 1
	for index, value in pairs(DEFAULT_CHAT_EDITBOX.lastTell) do
		temp = 1
		if value and string.len(value) > 0 then
			info = {}
			info.text = value
			for index2, value2 in pairs(DEFAULT_CHAT_EDITBOX.tell) do
				if value2 and string.len(value2) > 0 then
					info2 = {}
					info2.text = value2 
					if info2.text == info.text then temp = nil end
				end
			end
	
			if temp then
				info.value	= value
				info.notCheckable = 1
				info.func = function(this) 
								ChatFrame_SendTell(this.value)
							end
				info.owner = DropDownframe
				UIDropDownMenu_AddButton(info, 1)
			end
		end
	end
end

function SUI_ChannelChangeButton_OnClick(this, key)
	local chattype = {"SAY", "ZONE", "GUILD", "PARTY", "BG", "Whisper", "Whisper"}
	if this:GetID() == 3 then
		if key == "LBUTTON" then
			ChatEditMenu_SetChatType(DEFAULT_CHAT_EDITBOX, chattype[this:GetID()])
		else
			ToggleDropDownMenu(SUI_GuildChannelDropDownMenu, 1, nil, "cursor" , 0 , 0)
		end
	elseif this:GetID() < 6 then
		if key == "LBUTTON" then
			ChatEditMenu_SetChatType(DEFAULT_CHAT_EDITBOX, chattype[this:GetID()])
		end
	elseif this:GetID() < 7 then
		if key == "LBUTTON" then
			ChatEdit_RepeatTell()
			local telltarget = ChatEdit_GetTellTarget(DEFAULT_CHAT_EDITBOX)
			if string.len(telltarget) == 0 then
				ChatFrame1:AddMessage(CHAT_EDIT_WHISPER_TO_NIL)
			end
		else
			ChatFrameDropDown.hyperlinkType = "RepeatTell"
			ToggleDropDownMenu(SUI_WisperChannelDropDownMenu, 1, nil, "cursor" , 0 , 0)
		end
	elseif this:GetID() == 7 then
		ChatEditMenu_SetChatType(DEFAULT_CHAT_EDITBOX, "YELL")
	else
		local id = this:GetID()
		local k = id - 7
		if key == "LBUTTON" then
			DEFAULT_CHAT_EDITBOX.channelTarget = tonumber(this:GetID() - 7)
			ChatEditMenu_SetChatType(DEFAULT_CHAT_EDITBOX, "CHANNEL")
		else
			ChannelChangeDropDown.ChannelID = this:GetID() - 7
			ChannelChangeDropDown.ChannelName = GetChannelName(this:GetID() - 7)
			ToggleDropDownMenu(ChannelChangeDropDown, 1, nil, "cursor" , 0 , 0)
		end
	end
end

function SUI_ChannelChangeButton_OnEnter(this)
	GameTooltip:SetOwner(this, "ANCHOR_TOPRIGHT", -16, 0)

	local id = this:GetID()
	local _id = id-7
	local msg;
	local a1 , a2 = Sixteen(ChannelChange_Color[id].a)
	local r1 , r2 = Sixteen(ChannelChange_Color[id].r)
	local g1 , g2 = Sixteen(ChannelChange_Color[id].g)
	local b1 , b2 = Sixteen(ChannelChange_Color[id].b)

	local temp = a1..a2..r1..r2..g1..g2..b1..b2
	local name = GetChannelName(_id)

	if id == 1 then  							
		msg = "|c"..temp..CHAT_EDIT_SAY.."|r"
	elseif( id == 2 ) then
		msg = "|c"..temp..CHAT_EDIT_ZONE.."|r"
	elseif( id == 3 ) then
		msg = "|c"..temp..CHAT_EDIT_GUILD.."|r"
	elseif( id == 4 ) then		
		msg = "|c"..temp..CHAT_EDIT_PARTY.."|r"
	elseif( id == 5 ) then
		msg = "|c"..temp..CHAT_EDIT_BG.."|r"
	elseif( id == 6 ) then
		msg ="|c"..temp..CHAT_EDIT_WHISPER.."|r\n"
	elseif( id == 7 ) then
		msg = "|cffc28ff0"..CHAT_EDIT_YELL.."|r\n"
	elseif( id >= 8 and id <= 16 ) then
		msg ="|c"..temp..name.."|r"
	else
		msg=""
	end

	GameTooltip:SetText(msg)
	if id == 6 or id == 3 then
		GameTooltip:AddLine(CHANNEL_CHANGE_WHISPER_TIPS)
	end
	GameTooltip:Show()
end


function SUI_ChannelChangeFrame_OnLoad(this)
	ChatFrameChannelChange:UnregisterEvent("VARIABLES_LOADED")
	ChatFrameChannelChange:UnregisterEvent("CHAT_MSG_SAY")
	ChatFrameChannelChange:UnregisterEvent("CHAT_MSG_ZONE")
	ChatFrameChannelChange:UnregisterEvent("CHAT_MSG_GUILD")
	ChatFrameChannelChange:UnregisterEvent("CHAT_MSG_PARTY")
	ChatFrameChannelChange:UnregisterEvent("CHAT_MSG_BG")
	ChatFrameChannelChange:UnregisterEvent("CHAT_MSG_WHISPER")
	ChatFrameChannelChange:UnregisterEvent("CHAT_MSG_WHISPER_INFORM")
	ChatFrameChannelChange:UnregisterEvent("CHAT_MSG_CHANNEL")
	ChatFrameChannelChange:UnregisterEvent("PARTY_MEMBER_CHANGED")
	ChatFrameChannelChange:UnregisterEvent("PARTY_LEADER_CHANGED")
	ChatFrameChannelChange:UnregisterEvent("ZONE_CHANGED")
	ChatFrameChannelChange:UnregisterEvent("ON_BATTLEGROUND_CLOSE")
	ChatFrameChannelChange:UnregisterEvent("Guild_Board_Result")
	ChatFrameChannelChange:UnregisterEvent("CHAT_MSG_CHANNEL_JOIN")
	ChatFrameChannelChange:UnregisterEvent("CHAT_MSG_CHANNEL_LEAVE")
	ChatFrameChannelChange:UnregisterEvent("CHAT_MSG_CHANNEL_CREATE")
	ChatFrameChannelChange:UnregisterEvent("CHAT_MSG_CHANNEL_COLOR_CHANGE")
	
	GameConfigFramePagebut6:Hide()
	ChatFrameChannelChange_OnShow = function() ChatFrameChannelChange:Hide() end
	
	ChatFrameEditBoxMenuButton:Hide()
	ChatFrameRestoreButton:Hide()
	ChatFrameEmoteButton:Hide()
	
	this:RegisterEvent("VARIABLES_LOADED")
	this:RegisterEvent("PARTY_MEMBER_CHANGED")
	this:RegisterEvent("PARTY_LEADER_CHANGED")
	this:RegisterEvent("ZONE_CHANGED") 
	this:RegisterEvent("ON_BATTLEGROUND_CLOSE")
	this:RegisterEvent("Guild_Board_Result")
	this:RegisterEvent("CHAT_MSG_CHANNEL_JOIN")
	this:RegisterEvent("CHAT_MSG_CHANNEL_LEAVE")
	this:RegisterEvent("CHAT_MSG_CHANNEL_COLOR_CHANGE")
	
	for i = 2, 16 do
		getglobal("SUI_ChannelChangeButton"..i):ClearAllAnchors()
		getglobal("SUI_ChannelChangeButton"..i):SetAnchor("LEFT", "RIGHT", "SUI_ChannelChangeButton"..i - 1)
	end
	--SaveVariables("ParseChat")
end

function SUI_ChannelChangeFrame_OnEvent(this, event)
	if event == "VARIABLES_LOADED" then
		ChannelChange_Color_Init()
		SUI_ChannelChangeFrame_Initialize()
	elseif event == "PARTY_MEMBER_CHANGED" or event == "PARTY_LEADER_CHANGED" then
		if GetNumPartyMembers() > 0 and g_GCF_Page6.color_4 then
			SUI_ChannelChangeButton4:Show()
		else
			SUI_ChannelChangeButton4:Hide()
		end
		SUI_ChannelChangeFrame_SetOrder()
	elseif event == "ZONE_CHANGED" then  
		if  IsBattleGroundZone() and g_GCF_Page6.color_5  then
			SUI_ChannelChangeButton5:Show()
		else
			SUI_ChannelChangeButton5:Hide()
		end
		SUI_ChannelChangeFrame_SetOrder()	
	elseif event == "ON_BATTLEGROUND_CLOSE" then
		SUI_ChannelChangeButton5:Hide()
	elseif event == "Guild_Board_Result" then  
		if IsInGuild() and g_GCF_Page6.color_ then
			SUI_ChannelChangeButton3:Show()
		else
			SUI_ChannelChangeButton3:Hide()
		end
		SUI_ChannelChangeFrame_SetOrder()
	elseif event == "CHAT_MSG_CHANNEL_LEAVE" then
		local id = arg1
		local button = getglobal("SUI_ChannelChangeButton"..id + 7)
		button:Hide()
		SUI_ChannelChangeFrame_SetOrder()
	elseif event == "CHAT_MSG_CHANNEL_JOIN" then
		local id = arg1
		local button = getglobal("SUI_ChannelChangeButton"..id + 7)
		button:Show()
		SUI_ChannelChangeFrame_SetOrder()
	elseif event == "CHAT_MSG_CHANNEL_COLOR_CHANGE" then
		local chattype = {"SAY", "ZONE", "GUILD", "PARTY", "BG", "Whisper", "Whisper"}
		local r, g, b
		for i = 1 , 16 do
			if i < 7 then
				r, g, b = GetChannelColor(chattype[i])
			elseif i == 7 then
				--
			else
				r, g, b = GetChannelColor("CHANNEL"..i - 7)
			end
			
			if i ~= 7 then
				local button = getglobal( "SUI_ChannelChangeButton"..i)
				button:GetNormalTexture():SetColor(ChannelChange_Color[i].r , ChannelChange_Color[i].g , ChannelChange_Color[i].b)
				button:GetNormalTexture():SetAlpha(ChannelChange_Color[i].a)
			end
		end
		
		ChatChannelSetFrame_Okay()
		SUI_ChannelChangeFrame_SetOrder()
	end
	
	if GameConfigFrame:IsVisible() then
		-- GCF_Page6_Initial()
	end
end

function SUI_ChannelChangeFrame_OnUpdate(this)
	if os then
		SUI_ChatFrameTime:SetText(os.date("%H:%M"))
	end
	SUI_ChatFrameFPS:SetText(string.format("%.0ffps", GetFramerate()))
	SUI_ChatFramePing:SetText(string.format("%.0fms", GetPing()))
end

function SUI_ChannelChangeFrame_OnEnter(this)
	local type = DEFAULT_CHAT_EDITBOX.chatType
	if not type then
		return
	end

	local info = ChatTypeInfo[type]
	local text = ""
	
	if type == "WHISPER" then
		text = string.format(CHAT_WHISPER_SEND, DEFAULT_CHAT_EDITBOX.tellTarget)
	elseif type == "EMOTE" then
		text = string.format(CHAT_EMOTE_SEND, UnitName("player"))
	elseif type == "CHANNEL" then
		local channelName = GetChannelName(DEFAULT_CHAT_EDITBOX.channelTarget)
		local channel = DEFAULT_CHAT_EDITBOX.channelTarget
		info = ChatTypeInfo["CHANNEL"..channel]
		if channelName ~= "" then
			text = string.format(CHAT_CHANNEL_SEND, channel, channelName)
		end
	else
		text = getglobal("CHAT_"..type.."_SEND")
	end
	GameTooltip:SetOwner(this, "ANCHOR_TOPRIGHT", -358, 0)
	GameTooltip:SetText(text, info.r, info.g, info.b)
end

function SUI_ChannelChangeFrame_Initialize()
	local r, g, b
	for i = 1, 16 do
		local button = getglobal( "SUI_ChannelChangeButton"..i)
		button:GetNormalTexture():SetColor(ChannelChange_Color[i].r , ChannelChange_Color[i].g , ChannelChange_Color[i].b)
		button:GetNormalTexture():SetAlpha(ChannelChange_Color[i].a)
	end
	
	SUI_ChannelChangeButton7:GetNormalTexture():SetColor(0.76, 0.56, 0.94)
	SUI_ChannelChangeButton7:GetNormalTexture():SetAlpha(1)
	SUI_ChannelChangeButton7:Show()
	
	if g_GCF_Page6.color_1 then
		SUI_ChannelChangeButton1:Show()
	else
		SUI_ChannelChangeButton1:Hide()
	end

	if g_GCF_Page6.color_2 then
		SUI_ChannelChangeButton2:Show()
	else
		SUI_ChannelChangeButton2:Hide()
	end

	if IsInGuild() and g_GCF_Page6.color_3 then
		SUI_ChannelChangeButton3:Show()
	else
		SUI_ChannelChangeButton3:Hide()
	end

	if GetNumPartyMembers() > 0 and g_GCF_Page6.color_4 then
		SUI_ChannelChangeButton4:Show()
	else
		SUI_ChannelChangeButton4:Hide()
	end

	if IsBattleGroundZone() and g_GCF_Page6.color_5 then
		SUI_ChannelChangeButton5:Show()
	else
		SUI_ChannelChangeButton5:Hide()
	end

	if g_GCF_Page6.color_6 then
		SUI_ChannelChangeButton6:Show()
	else
		SUI_ChannelChangeButton6:Hide()
	end
	
	for i = 8, 16 do
		local button = getglobal("SUI_ChannelChangeButton"..i)
		if GetChannelName(i) ~= "" then
			button:Show()
		else
			button:Hide()
		end
	end
	SUI_ChannelChangeFrame_SetOrder()
end

function SUI_ChannelChangeFrame_SetOrder()
	local parent = SUI_ChannelChangeButton1
	for i = 2, 16 do
		local button = getglobal("SUI_ChannelChangeButton"..i)
		if button:IsVisible() then
			button:ClearAllAnchors()
			button:SetAnchor("LEFT", "RIGHT", parent, 0, 0)
			parent = button
		end
	end
end


function SUI_ChatFrameEditBox_OnClick(this)
	if DEFAULT_CHAT_EDITBOX:IsVisible() and DEFAULT_CHAT_EDITBOX:GetText() == "" then
		DEFAULT_CHAT_EDITBOX:Hide()
	end
end

function SUI_MacroButton_OnClick(this)
	if IsAltKeyDown() and IsCtrlKeyDown() then
		ReloadUI()
	else
		ToggleUIFrame(MacroFrame)
	end
end


function FCF_SetTabPosition(chatFrame, x)
	local chatTab = getglobal(chatFrame:GetName().."Tab");
	chatTab:ClearAllAnchors();
	chatTab:SetAnchor("BOTTOMLEFT", "TOPLEFT", chatFrame:GetName(), x, 0);
end

function FCF_DockUpdate()
	local numDockedFrames = table.getn(DOCKED_CHAT_FRAMES);
	local chatTab, previousDockedFrame;
	local dockWidth = 0;
	local name;	
	for index, value in pairs(DOCKED_CHAT_FRAMES) do
		name = value:GetName();
		if ( index ~= 1 ) then
			value:ClearAllAnchors();
			value:SetAnchor("TOPLEFT", "TOPLEFT", DEFAULT_CHAT_FRAME, 0, 0);
			value:SetAnchor("BOTTOMRIGHT", "BOTTOMRIGHT", DEFAULT_CHAT_FRAME, 0, 0);
		end
		chatTab = getglobal(value:GetName().."Tab");
		if ( value == SELECTED_DOCK_FRAME ) then
			value:Show();
			if ( chatTab:IsVisible() ) then
				chatTab:SetAlpha(1.0);
			end
		else
			value:Hide();
			if ( chatTab:IsVisible() ) then
				chatTab:SetAlpha(0.5);
			end
		end
		
		if ( previousDockedFrame ) then
			FCF_SetTabPosition(value, dockWidth);
		end
		
		dockWidth = dockWidth + chatTab:GetWidth();
		previousDockedFrame = value;
	end
end

function FCF_SetWindowColor(frame, r, g, b, doNotSave)
	frame:SetBackdropTileColor(r, g, b);
	if ( not doNotSave ) then
		SetChatWindowColor(frame:GetID(), r, g, b);
	end
end

function FCF_SetWindowAlpha(frame, alpha, doNotSave)
	frame:SetBackdropTileAlpha(alpha);
	if ( not doNotSave ) then
		SetChatWindowAlpha(frame:GetID(), alpha);
	end
	frame.oldAlpha = alpha;
end

function ChatEdit_UpdateHeader(editBox)
	local type = editBox.chatType;
	if ( not type ) then
		return;
	end

	local info = ChatTypeInfo[type];
	local header = getglobal(editBox:GetName().."Header");
	if ( not header ) then
		return;
	end

	if ( type == "WHISPER" ) then
		header:SetText( string.format(CHAT_WHISPER_SEND, editBox.tellTarget) );
	elseif ( type == "EMOTE" ) then
		header:SetText( string.format(CHAT_EMOTE_SEND, UnitName("player")) );
	elseif ( type == "CHANNEL" ) then
		local channelName = GetChannelName(editBox.channelTarget);
		local channel = editBox.channelTarget;
		info = ChatTypeInfo["CHANNEL"..channel];
		if ( channelName ~= "" ) then
			header:SetText( string.format(CHAT_CHANNEL_SEND, channel, channelName));
		end
	else
		header:SetText( getglobal("CHAT_"..type.."_SEND") );
	end

	header:SetColor(info.r, info.g, info.b);

	editBox:SetTextInset(4 + header:GetWidth(), 4, 0, 0);
	editBox:SetTextColor(info.r, info.g, info.b);
end

function ChatMenuDropDown_Show(this)
	local info;
	if ( UIDROPDOWNMENU_MENU_LEVEL == 1 ) then
		info = {};
		info.isTitle = 1;
		info.text = TEXT("CHANNEL");
		UIDropDownMenu_AddButton(info);
	
		info = {};	
		info.text = TEXT("CHANNEL_SET");
		info.value = "CHANNEL_SET";
		info.func = ChatMenuDropDown_Click;
		UIDropDownMenu_AddButton(info);
		
		info = {};	
		info.text = TEXT("CHANNEL_CREATE");
		info.value = "CHANNEL_CREATE";
		info.func = ChatMenuDropDown_Click;
		UIDropDownMenu_AddButton(info);
	
		info = {};
		info.text = TEXT("CHANNEL_JOIN");
		info.value = "CHANNEL_JOIN";
		info.func = ChatMenuDropDown_Click;
		UIDropDownMenu_AddButton(info);
	
		info = {};
		info.isTitle = 1;
		info.text = TEXT("CHAT_TAB");
		info.value = "CHAT_TAB";
		UIDropDownMenu_AddButton(info);
		
		if ( not SELECTED_CHAT_FRAME.isDocked ) then
			info = {};
			info.text = TEXT("CHANEEL_DOCKED");
			info.value = "CHANEEL_DOCKED";
			info.func = ChatMenuDropDown_Click;
			UIDropDownMenu_AddButton(info);
		end
		
		info = {};
		info.text = TEXT("CHANNEL_CREATE_TAB");
		info.value = "CREATE_TAB";
		info.func = ChatMenuDropDown_Click;
		UIDropDownMenu_AddButton(info);
	
		info = {};
		info.text = TEXT("CHANNEL_DELETE_TAB");
		info.value = "DELETE_TAB";
		info.func = ChatMenuDropDown_Click;
		UIDropDownMenu_AddButton(info);
	
		info = {};
		info.text = TEXT("CHANNEL_LOCKED_TAB");
		info.value = "LOCKED_TAB";
		info.checked = SELECTED_CHAT_FRAME.isLocked
		info.func = ChatMenuDropDown_Click;
		UIDropDownMenu_AddButton(info);
		
		info = {};
		info.text = TEXT("CHANNEL_RENAME_TAB");
		info.value = "RENAME_TAB";
		info.func = ChatMenuDropDown_Click;
		UIDropDownMenu_AddButton(info);
		
		info = {};
		info.text = TEXT("CHANNEL_BGCOLOR");
		info.value = "BGCOLOR";
		info.func = ChatMenuDropDown_Click;
		UIDropDownMenu_AddButton(info);
		
		info = {};
		info.text = TEXT("CHANEEL_FONTSIZE");
		info.value = "FONTSIZE";
		info.hasArrow = 1;
		UIDropDownMenu_AddButton(info);
		
		info = {};
		info.text = OBJ_RESET;
		info.value = "RESETUI";
		info.func = ChatMenuDropDown_Click;
		UIDropDownMenu_AddButton(info);
	elseif ( UIDROPDOWNMENU_MENU_LEVEL == 2 ) then
		if ( UIDROPDOWNMENU_MENU_VALUE == "FONTSIZE" ) then
			local name, fontSize = GetChatWindowInfo(SELECTED_CHAT_FRAME:GetID());
			info = {};
			info.text = TEXT("12");
			info.value = 12;
			info.checked = fontSize == 12;
			info.func = ChatMenuFontSizeDropDown_Click;
			UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
			
			info = {};
			info.text = TEXT("13");
			info.value = 13;
			info.checked = fontSize == 13;
			info.func = ChatMenuFontSizeDropDown_Click;
			UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
			
			info = {};
			info.text = TEXT("14");
			info.value = 14;
			info.checked = fontSize == 14;
			info.func = ChatMenuFontSizeDropDown_Click;
			UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
			
			info = {};
			info.text = TEXT("15");
			info.value = 15;
			info.checked = fontSize == 15;
			info.func = ChatMenuFontSizeDropDown_Click;
			UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
			
			info = {};
			info.text = TEXT("16");
			info.value = 16;
			info.checked = fontSize == 16;
			info.func = ChatMenuFontSizeDropDown_Click;
			UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
		end
	end
end

function ChatMenuDropDown_Click(button)
	local chatFrame = SELECTED_CHAT_FRAME;
	if ( button.value == "BGCOLOR" ) then
		OpenColorPickerFrame(ChatFrameBackground_SetColor, 1);
	elseif ( button.value == "RENAME_TAB" ) then
		StaticPopup_Show("RENAME_CHANNEL");
	elseif ( button.value == "LOCKED_TAB" ) then
		FCF_SetLocked(chatFrame, not chatFrame.isLocked);
	elseif ( button.value == "DELETE_TAB" ) then
		FCF_Close(chatFrame);
	elseif ( button.value == "CREATE_TAB" ) then
		FCF_OpenNewWindow();
	elseif ( button.value == "CHANNEL_JOIN" ) then
		StaticPopup_Show("JOIN_CHANNEL");
	elseif ( button.value == "CHANNEL_CREATE" ) then
		StaticPopup_Show("CREATE_CHANNEL");
	elseif ( button.value == "CHANNEL_SET" ) then
		ChatChannelSetFrame_Open(chatFrame, GetChannelList());
	elseif ( button.value == "CHANEEL_DOCKED" ) then
		FCF_DockFrame(chatFrame);
	elseif ( button.value == "RESETUI" ) then
		ResetUI();
	end
end

UIDropDownMenu_Initialize(ChatMenuDropDown, ChatMenuDropDown_Show, "MENU")